/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mvel2.compiler;

import shaded.org.mvel2.ast.ASTNode;
import shaded.org.mvel2.ast.Safe;
import shaded.org.mvel2.ast.TypeCast;
import shaded.org.mvel2.compiler.ExecutableStatement;
import shaded.org.mvel2.integration.VariableResolverFactory;

public class ExecutableAccessorSafe
implements ExecutableStatement,
Safe {
    private ASTNode node;
    private Class ingress;
    private Class egress;
    private boolean convertable;

    public ExecutableAccessorSafe(ASTNode node) {
        this.node = node;
    }

    public ExecutableAccessorSafe(ASTNode node, Class returnType) {
        this.node = node;
        this.egress = returnType;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        return this.node.getReducedValueAccelerated(ctx, elCtx, variableFactory);
    }

    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        return this.node.getReducedValueAccelerated(staticContext, staticContext, factory);
    }

    public void setKnownIngressType(Class type) {
        this.ingress = type;
    }

    public void setKnownEgressType(Class type) {
        this.egress = type;
    }

    public Class getKnownIngressType() {
        return this.ingress;
    }

    public Class getKnownEgressType() {
        return this.egress;
    }

    public boolean isConvertableIngressEgress() {
        return this.convertable;
    }

    public void computeTypeConversionRule() {
        if (this.ingress != null && this.egress != null) {
            this.convertable = this.ingress.isAssignableFrom(this.egress);
        }
    }

    public boolean intOptimized() {
        return false;
    }

    public ASTNode getNode() {
        return this.node;
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return null;
    }

    public boolean isLiteralOnly() {
        return false;
    }

    public boolean isEmptyStatement() {
        return this.node == null;
    }

    public boolean isExplicitCast() {
        return this.node != null && this.node instanceof TypeCast;
    }
}

