/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mvel2.util;

import shaded.org.mvel2.util.NullType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibilityStrategy {
    public static CompatibilityEvaluator compatibilityEvaluator = new DefaultCompatibilityEvaluator();

    private CompatibilityStrategy() {
    }

    public static boolean areEqualityCompatible(Class<?> c1, Class<?> c2) {
        return compatibilityEvaluator.areEqualityCompatible(c1, c2);
    }

    public static boolean areComparisonCompatible(Class<?> c1, Class<?> c2) {
        return compatibilityEvaluator.areComparisonCompatible(c1, c2);
    }

    public static void setCompatibilityEvaluator(CompatibilityEvaluator compatibilityEvaluator) {
        CompatibilityStrategy.compatibilityEvaluator = compatibilityEvaluator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultCompatibilityEvaluator
    implements CompatibilityEvaluator {
        @Override
        public boolean areEqualityCompatible(Class<?> c1, Class<?> c2) {
            if (c1 == NullType.class || c2 == NullType.class) {
                return true;
            }
            if (c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1)) {
                return true;
            }
            if (this.isBoxedNumber(c1, false) && this.isBoxedNumber(c2, true)) {
                return true;
            }
            if (c1.isPrimitive()) {
                return c2.isPrimitive() || this.arePrimitiveCompatible(c1, c2, true);
            }
            if (c2.isPrimitive()) {
                return this.arePrimitiveCompatible(c2, c1, false);
            }
            return false;
        }

        @Override
        public boolean areComparisonCompatible(Class<?> c1, Class<?> c2) {
            return this.areEqualityCompatible(c1, c2);
        }

        private boolean arePrimitiveCompatible(Class<?> primitive, Class<?> boxed, boolean leftFirst) {
            if (primitive == Boolean.TYPE) {
                return boxed == Boolean.class;
            }
            if (primitive == Integer.TYPE) {
                return this.isBoxedNumber(boxed, leftFirst);
            }
            if (primitive == Long.TYPE) {
                return this.isBoxedNumber(boxed, leftFirst);
            }
            if (primitive == Double.TYPE) {
                return this.isBoxedNumber(boxed, leftFirst);
            }
            if (primitive == Float.TYPE) {
                return this.isBoxedNumber(boxed, leftFirst);
            }
            if (primitive == Character.TYPE) {
                return boxed == Character.class;
            }
            if (primitive == Byte.TYPE) {
                return boxed == Byte.class;
            }
            if (primitive == Short.TYPE) {
                return boxed == Short.class;
            }
            return false;
        }

        private boolean isBoxedNumber(Class<?> c, boolean allowString) {
            return Number.class.isAssignableFrom(c) || allowString && c == String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CompatibilityEvaluator {
        public boolean areEqualityCompatible(Class<?> var1, Class<?> var2);

        public boolean areComparisonCompatible(Class<?> var1, Class<?> var2);
    }
}

