/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.agent.opentracing;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.hawkular.apm.api.logging.Logger;
import org.jboss.byteman.agent.Retransformer;

public class OpenTracingRuleLoader {
    private static final Logger log = Logger.getLogger(OpenTracingRuleLoader.class.getName());
    private static final String RULE_FILE_EXTENSION = ".btm";
    private static final String ROOT_RULE_FOLDER = "/rules";
    private static Retransformer transformer;

    public static void initialize(Retransformer trans) throws Exception {
        transformer = trans;
        URI uri = OpenTracingRuleLoader.class.getResource(ROOT_RULE_FOLDER).toURI();
        String s = uri.toString();
        int separator = s.indexOf("!/");
        String entryName = s.substring(separator + 2);
        URI fileURI = URI.create(s.substring(0, separator));
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<String> scriptNames = new ArrayList<String>();
        try (FileSystem fs = FileSystems.newFileSystem(fileURI, Collections.emptyMap());){
            Path rules = fs.getPath(entryName, new String[0]);
            Files.walk(rules, new FileVisitOption[0]).filter(f -> f.toString().endsWith(RULE_FILE_EXTENSION)).forEach(f -> {
                try {
                    scripts.add(new String(Files.readAllBytes(f)));
                    scriptNames.add(f.toString());
                }
                catch (IOException ioe) {
                    log.log(Logger.Level.SEVERE, "Failed to load rule file: " + f.toString(), ioe);
                }
            });
        }
        var9_9 = null;
        try (PrintWriter writer = new PrintWriter(new StringWriter());){
            transformer.installScript(scripts, scriptNames, writer);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        if (log.isLoggable(Logger.Level.FINE)) {
            log.fine("Installed rules");
        }
    }
}

