/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.agent.opentracing.propagation.jax;

import io.opentracing.propagation.TextMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.apm.api.logging.Logger;

public final class HttpServletRequestExtractAdapter
implements TextMap {
    private static final Logger log = Logger.getLogger(HttpServletRequestExtractAdapter.class.getName());
    private final Object request;
    private static Method reqGetHeaderNames;
    private static Method reqGetHeader;

    public HttpServletRequestExtractAdapter(Object request) {
        this.request = request;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (reqGetHeaderNames == null) {
                reqGetHeaderNames = this.request.getClass().getMethod("getHeaderNames", new Class[0]);
            }
            if (reqGetHeader == null) {
                reqGetHeader = this.request.getClass().getMethod("getHeader", String.class);
            }
            Enumeration names = (Enumeration)reqGetHeaderNames.invoke(this.request, new Object[0]);
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = (String)reqGetHeader.invoke(this.request, name);
                map.put(name, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException t) {
            log.log(Logger.Level.WARNING, "Failed to get headers", t);
        }
        return map.entrySet().iterator();
    }

    @Override
    public void put(String key, String value) {
        throw new UnsupportedOperationException("HttpServletRequestExtractAdapter should only be used with Tracer.extract()");
    }
}

