/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.ApmEvent;

public class CompletionTime
implements ApmEvent {
    @JsonInclude
    private String id;
    @JsonInclude
    private String uri;
    @JsonInclude
    private String operation;
    @JsonInclude
    private String endpointType;
    @JsonInclude
    private String transaction;
    @JsonInclude
    private long timestamp = 0L;
    @JsonInclude
    private long duration = 0L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String hostName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String hostAddress;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<Property> properties = new HashSet<Property>();
    @JsonInclude
    private boolean internal = false;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<Property> getProperties(String name) {
        HashSet<Property> ret = new HashSet<Property>();
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            ret.add(property);
        }
        return ret;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public String toString() {
        return "CompletionTime [id=" + this.id + ", uri=" + this.uri + ", operation=" + this.operation + ", endpointType=" + this.endpointType + ", transaction=" + this.transaction + ", timestamp=" + this.timestamp + ", duration=" + this.duration + ", hostName=" + this.hostName + ", hostAddress=" + this.hostAddress + ", properties=" + this.properties + ", internal=" + this.internal + "]";
    }
}

