/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.api.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.services.Criteria;
import org.hawkular.apm.api.services.ServiceStatus;
import org.hawkular.apm.api.utils.PropertyUtil;

public class AbstractRESTClient
implements ServiceStatus {
    private static final Logger log = Logger.getLogger(AbstractRESTClient.class.getName());
    private static final String HAWKULAR_TENANT = "Hawkular-Tenant";
    protected static final ObjectMapper mapper = new ObjectMapper();
    private String username = PropertyUtil.getProperty("HAWKULAR_APM_USERNAME");
    private String password = PropertyUtil.getProperty("HAWKULAR_APM_PASSWORD");
    private String authorization = null;
    private String uri;
    private static final Base64.Encoder encoder = Base64.getEncoder();

    public AbstractRESTClient(String uriProperty) {
        this.uri = PropertyUtil.getProperty(uriProperty, PropertyUtil.getProperty("HAWKULAR_APM_URI"));
        if (this.uri != null && !this.uri.isEmpty() && this.uri.charAt(this.uri.length() - 1) != '/') {
            this.uri = this.uri + '/';
        }
    }

    @Override
    public boolean isAvailable() {
        return this.uri != null && this.uri.startsWith("http");
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId == null) {
            tenantId = PropertyUtil.getProperty("HAWKULAR_TENANT");
        }
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_TENANT, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = encoder.encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }

    public URL getUrl(String path, Object ... args) {
        return this.getUrl(String.format(path, args));
    }

    public URL getUrl(String path) {
        try {
            return new URL(this.getUri() + "hawkular/apm/" + path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T withContext(String tenantId, URL url, Function<HttpURLConnection, T> function) {
        HttpURLConnection connection = null;
        try {
            connection = this.getConnectionForGetRequest(tenantId, url);
            T t = function.apply(connection);
            return t;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public <T> T getResultsForUrl(String tenantId, TypeReference<T> typeReference, String path, Object ... parameters) {
        return (T)this.withContext(tenantId, this.getUrl(path, parameters), connection -> this.parseResultsIntoJson((HttpURLConnection)connection, typeReference));
    }

    public <T> T parseResultsIntoJson(HttpURLConnection connection, TypeReference<T> typeReference) {
        try {
            String response = this.getResponse(connection);
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + response + "]");
                }
                if (!response.trim().isEmpty()) {
                    try {
                        return mapper.readValue(response, typeReference);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get results: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get results", e);
        }
        return null;
    }

    public <T> T getResultsForUrl(String tenantId, TypeReference<T> typeReference, String path, Criteria criteria) {
        return this.getResultsForUrl(tenantId, typeReference, path, this.encodedCriteria(criteria));
    }

    public <T> T getResultsForUrl(String tenantId, TypeReference<T> typeReference, String path, Criteria criteria, Object arg) {
        return this.getResultsForUrl(tenantId, typeReference, path, this.encodedCriteria(criteria), arg);
    }

    public String encodedCriteria(Criteria criteria) {
        try {
            return URLEncoder.encode(mapper.writeValueAsString(criteria), "UTF-8");
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpURLConnection getConnectionForGetRequest(String tenantId, URL url) throws IOException {
        return this.getConnectionForRequest(tenantId, url, "GET");
    }

    public HttpURLConnection getConnectionForRequest(String tenantId, URL url, String method) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        this.addHeaders(connection, tenantId);
        return connection;
    }

    public String getResponse(HttpURLConnection connection) throws IOException {
        String response;
        InputStream is = connection.getInputStream();
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is));){
            response = buffer.lines().collect(Collectors.joining("\n"));
        }
        return response;
    }

    public int postAsJsonTo(String tenantId, String path, Object toSerialize) {
        URL url = this.getUrl(path);
        return this.withJsonPayloadAndResults("POST", tenantId, url, toSerialize, connection -> {
            try {
                return connection.getResponseCode();
            }
            catch (IOException e) {
                e.printStackTrace();
                log.log(Logger.Level.SEVERE, String.format("Failed to post to [%s]", url), e);
                return 0;
            }
        });
    }

    public <T> T withJsonPayloadAndResults(String method, String tenantId, URL url, Object toSerialize, Function<HttpURLConnection, T> function) {
        return (T)this.withContext(tenantId, url, connection -> {
            try {
                connection.setRequestMethod(method);
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                connection.setAllowUserInteraction(false);
                connection.setRequestProperty("Content-Type", "application/json");
                OutputStream os = connection.getOutputStream();
                os.write(mapper.writeValueAsBytes(toSerialize));
                os.flush();
                os.close();
                return function.apply((HttpURLConnection)connection);
            }
            catch (IOException e) {
                e.printStackTrace();
                log.log(Logger.Level.SEVERE, String.format("Failed to post to [%s]", url), e);
                return null;
            }
        });
    }

    public void clear(String tenantId, String path) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest(String.format("Clear service at path [%s] for tenant [%s]", path, tenantId));
        }
        URL url = this.getUrl(path);
        this.withContext(tenantId, url, connection -> {
            try {
                connection.setRequestMethod("DELETE");
                if (connection.getResponseCode() == 200) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest(String.format("Service at [%s] cleared", path));
                    }
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.warning("Failed to clear analytics: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.log(Logger.Level.SEVERE, String.format("Failed to send 'clear' request to service [%s]", path), e);
            }
            return null;
        });
    }
}

