/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.properties;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.picketlink.common.properties.MethodProperty;
import org.picketlink.common.reflection.Reflections;

class MethodPropertyImpl<V>
implements MethodProperty<V> {
    private static final String GETTER_METHOD_PREFIX = "get";
    private static final String SETTER_METHOD_PREFIX = "set";
    private static final String BOOLEAN_GETTER_METHOD_PREFIX = "is";
    private static final int GETTER_METHOD_PREFIX_LENGTH = "get".length();
    private static final int SETTER_METHOD_PREFIX_LENGTH = "set".length();
    private static final int BOOLEAN_GETTER_METHOD_PREFIX_LENGTH = "is".length();
    private final Method getterMethod;
    private final String propertyName;
    private final Method setterMethod;

    public MethodPropertyImpl(Method method) {
        String accessorMethodPrefix;
        String propertyNameInAccessorMethod;
        if (method.getName().startsWith(GETTER_METHOD_PREFIX)) {
            if (method.getReturnType() == Void.TYPE) {
                throw new IllegalArgumentException("Invalid accessor method, must have return value if starts with 'get'. Method: " + method);
            }
            if (method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Invalid accessor method, must have zero arguments if starts with 'get'. Method: " + method);
            }
            propertyNameInAccessorMethod = method.getName().substring(GETTER_METHOD_PREFIX_LENGTH);
            accessorMethodPrefix = GETTER_METHOD_PREFIX;
        } else if (method.getName().startsWith(SETTER_METHOD_PREFIX)) {
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException("Invalid accessor method, must not have return value if starts with 'set'. Method: " + method);
            }
            if (method.getParameterTypes().length != 1) {
                throw new IllegalArgumentException("Invalid accessor method, must have one argument if starts with 'set'. Method: " + method);
            }
            propertyNameInAccessorMethod = method.getName().substring(SETTER_METHOD_PREFIX_LENGTH);
            accessorMethodPrefix = SETTER_METHOD_PREFIX;
        } else if (method.getName().startsWith(BOOLEAN_GETTER_METHOD_PREFIX)) {
            if (method.getReturnType() != Boolean.TYPE || !method.getReturnType().isPrimitive()) {
                throw new IllegalArgumentException("Invalid accessor method, must return boolean primitive if starts with 'is'. Method: " + method);
            }
            propertyNameInAccessorMethod = method.getName().substring(BOOLEAN_GETTER_METHOD_PREFIX_LENGTH);
            accessorMethodPrefix = BOOLEAN_GETTER_METHOD_PREFIX;
        } else {
            throw new IllegalArgumentException("Invalid accessor method, must start with 'get', 'set' or 'is'.  Method: " + method);
        }
        if (propertyNameInAccessorMethod.length() == 0 || !Character.isUpperCase(propertyNameInAccessorMethod.charAt(0))) {
            throw new IllegalArgumentException("Invalid accessor method, prefix '" + accessorMethodPrefix + "' must be followed a non-empty property name, capitalized. Method: " + method);
        }
        this.propertyName = Introspector.decapitalize(propertyNameInAccessorMethod);
        this.getterMethod = MethodPropertyImpl.getGetterMethod(method.getDeclaringClass(), this.propertyName);
        this.setterMethod = MethodPropertyImpl.getSetterMethod(method.getDeclaringClass(), this.propertyName);
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Class<V> getJavaClass() {
        return this.getterMethod.getReturnType();
    }

    @Override
    public Type getBaseType() {
        return this.getterMethod.getGenericReturnType();
    }

    @Override
    public Method getAnnotatedElement() {
        return this.getterMethod;
    }

    @Override
    public Member getMember() {
        return this.getterMethod;
    }

    @Override
    public V getValue(Object instance) {
        if (this.getterMethod == null) {
            throw new UnsupportedOperationException("Property " + this.setterMethod.getDeclaringClass() + "." + this.propertyName + " cannot be read, as there is no getter method.");
        }
        return (V)Reflections.cast(Reflections.invokeMethod(this.getterMethod, instance, new Object[0]));
    }

    @Override
    public void setValue(Object instance, V value) {
        if (this.setterMethod == null) {
            Method instanceSetterMethod;
            if (this.getDeclaringClass().isAssignableFrom(instance.getClass()) && (instanceSetterMethod = MethodPropertyImpl.getSetterMethod(instance.getClass(), this.getName())) != null) {
                Reflections.invokeMethod(instanceSetterMethod, instance, value);
                return;
            }
            throw new UnsupportedOperationException("Property " + this.getterMethod.getDeclaringClass() + "." + this.propertyName + " is read only, as there is no setter method.");
        }
        Reflections.invokeMethod(this.setterMethod, instance, value);
    }

    private static Method getSetterMethod(Class<?> clazz, String name) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith(SETTER_METHOD_PREFIX) || method.getParameterTypes().length != 1 || !Introspector.decapitalize(methodName.substring(SETTER_METHOD_PREFIX_LENGTH)).equals(name)) continue;
            return method;
        }
        return null;
    }

    private static Method getGetterMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 0 || !(methodName.startsWith(GETTER_METHOD_PREFIX) ? Introspector.decapitalize(methodName.substring(GETTER_METHOD_PREFIX_LENGTH)).equals(name) : methodName.startsWith(BOOLEAN_GETTER_METHOD_PREFIX) && Introspector.decapitalize(methodName.substring(BOOLEAN_GETTER_METHOD_PREFIX_LENGTH)).equals(name))) continue;
            return method;
        }
        throw new IllegalArgumentException("no such getter method: " + clazz.getName() + '.' + name);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getterMethod.getDeclaringClass();
    }

    @Override
    public boolean isReadOnly() {
        return this.setterMethod == null;
    }

    @Override
    public void setAccessible() {
        if (this.setterMethod != null) {
            Reflections.setAccessible(this.setterMethod);
        }
        if (this.getterMethod != null) {
            Reflections.setAccessible(this.getterMethod);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.getAnnotatedElement() != null && this.getAnnotatedElement().isAnnotationPresent(annotation);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isReadOnly()) {
            builder.append("read-only ").append(this.setterMethod.toString()).append("; ");
        }
        builder.append(this.getterMethod.toString());
        return builder.toString();
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.setterMethod == null ? 0 : this.setterMethod.hashCode());
        hash = hash * 31 + this.getterMethod.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodPropertyImpl) {
            MethodPropertyImpl that = (MethodPropertyImpl)obj;
            if (this.setterMethod == null) {
                return that.setterMethod == null && this.getterMethod.equals(that.getterMethod);
            }
            return this.setterMethod.equals(that.setterMethod) && this.getterMethod.equals(that.getterMethod);
        }
        return false;
    }
}

