/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.infinispan.subsystem.BackupOperationContext;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;

public class BackupOperationExecutor
implements OperationExecutor<BackupOperationContext> {
    public ModelNode execute(OperationContext context, Operation<BackupOperationContext> operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress cacheAddress = address.getParent();
        final String site = address.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = cacheAddress.getParent().getLastElement().getValue();
        final Cache cache = (Cache)ServiceContainerHelper.findValue((ServiceRegistry)context.getServiceRegistry(true), (ServiceName)CacheServiceName.CACHE.getServiceName(containerName, cacheName));
        BackupOperationContext operationContext = new BackupOperationContext(){

            @Override
            public String getSite() {
                return site;
            }

            @Override
            public XSiteAdminOperations getOperations() {
                return (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
            }
        };
        return cache != null ? operation.execute((Object)operationContext) : null;
    }
}

