/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support.finder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyReader;

public class URLPolicyFinderModule
extends PolicyFinderModule {
    private File schemaFile;
    private PolicyReader reader;
    private static final Logger logger = Logger.getLogger(URLPolicyFinderModule.class.getName());

    public URLPolicyFinderModule() {
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public URLPolicyFinderModule(String schemaFile) {
        this.schemaFile = new File(schemaFile);
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        this.reader = new PolicyReader(finder, logger, this.schemaFile);
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        URL url = null;
        try {
            url = new URL(idReference.toString());
        }
        catch (MalformedURLException murle) {
            return new PolicyFinderResult();
        }
        AbstractPolicy policy = null;
        try {
            policy = this.reader.readPolicy(url);
        }
        catch (ParsingException pe) {
            return new PolicyFinderResult();
        }
        if (type == 0 ? !(policy instanceof Policy) : !(policy instanceof PolicySet)) {
            return new PolicyFinderResult();
        }
        if (!constraints.meetsConstraint(policy.getVersion())) {
            return new PolicyFinderResult();
        }
        return new PolicyFinderResult(policy);
    }
}

