/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

abstract class PatchStreamResourceOperationStepHandler
implements OperationStepHandler {
    PatchStreamResourceOperationStepHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.acquireControllerLock();
        this.execute(context, operation, this.getInstallationManager(context), this.getPatchStreamName(context));
    }

    protected String getPatchStreamName(OperationContext context) {
        PathElement stream = context.getCurrentAddress().getLastElement();
        String streamName = "patch-stream".equals(stream.getKey()) ? stream.getValue() : null;
        return streamName;
    }

    protected void execute(OperationContext context, ModelNode operation, InstallationManager instMgr, String patchStream) throws OperationFailedException {
        InstalledIdentity installedIdentity;
        if (patchStream != null) {
            try {
                installedIdentity = instMgr.getInstalledIdentity(patchStream, null);
            }
            catch (PatchingException e) {
                throw new OperationFailedException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(patchStream), (Throwable)e);
            }
        } else {
            installedIdentity = instMgr.getDefaultIdentity();
        }
        this.execute(context, operation, installedIdentity);
    }

    protected void execute(OperationContext context, ModelNode operation, InstalledIdentity installedIdentity) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    protected InstallationManager getInstallationManager(OperationContext ctx) {
        ServiceController imController = ctx.getServiceRegistry(false).getRequiredService(InstallationManagerService.NAME);
        while (imController != null && imController.getState() == ServiceController.State.UP) {
            try {
                return (InstallationManager)imController.getValue();
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        return null;
    }
}

