/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

public final class SecurityDomainContextAdaptor
implements org.jboss.wsf.spi.security.SecurityDomainContext {
    private final SecurityDomainContext context;

    public SecurityDomainContextAdaptor(SecurityDomainContext context) {
        this.context = context;
    }

    public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
        return this.context.getAuthenticationManager().isValid(principal, credential, activeSubject);
    }

    public boolean doesUserHaveRole(Principal principal, Set<Principal> roles) {
        return this.context.getAuthorizationManager().doesUserHaveRole(principal, roles);
    }

    public String getSecurityDomain() {
        return this.context.getAuthenticationManager().getSecurityDomain();
    }

    public Set<Principal> getUserRoles(Principal principal) {
        return this.context.getAuthorizationManager().getUserRoles(principal);
    }

    public void pushSubjectContext(final Subject subject, final Principal principal, final Object credential) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
                if (securityContext == null) {
                    securityContext = SecurityDomainContextAdaptor.createSecurityContext(SecurityDomainContextAdaptor.this.getSecurityDomain());
                    SecurityDomainContextAdaptor.setSecurityContextOnAssociation(securityContext);
                }
                securityContext.getUtil().createSubjectInfo(principal, credential, subject);
                return null;
            }
        });
    }

    private static SecurityContext createSecurityContext(final String domain) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                try {
                    return SecurityContextFactory.createSecurityContext((String)domain);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }
}

