/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.agent.LocationType;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.agent.adapter.RuleMethodAdapter;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.type.Type;

public class RuleCheckMethodAdapter
extends RuleMethodAdapter {
    private List<Label> triggerPoints = null;
    private String returnBindingType;

    RuleCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor) {
        super(mv, transformContext, access, name, descriptor, transformContext.createRule(name, descriptor));
        this.returnBindingType = Type.parseMethodReturnType(descriptor);
    }

    protected String getReturnBindingType() {
        return this.returnBindingType;
    }

    protected void setTriggerPoint() {
        if (this.triggerPoints == null) {
            this.triggerPoints = new ArrayList<Label>();
        }
        Label triggerLabel = new Label();
        this.triggerPoints.add(triggerLabel);
        this.visitLabel(triggerLabel);
    }

    boolean isTriggerPoint() {
        return this.triggerPoints != null;
    }

    protected void checkBindings() {
        if (!this.isTriggerPoint()) {
            this.transformContext.warn(this.name, this.descriptor, "no matching injection point");
            return;
        }
        Bindings bindings = this.rule.getBindings();
        Iterator<Binding> bindingIter = bindings.iterator();
        List<String> parameterTypenames = Type.parseMethodDescriptor(this.descriptor, true);
        int parameterCount = parameterTypenames.size() - 1;
        while (bindingIter.hasNext()) {
            Binding binding = bindingIter.next();
            if (binding.isRecipient()) {
                if ((this.access & 8) == 0) continue;
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : found invalid recipient binding " + binding + " checking static method " + this.name + this.descriptor);
                }
                this.transformContext.warn(this.name, this.descriptor, "found invalid recipient binding " + binding + " injecting into static method");
                continue;
            }
            if (binding.isParam()) {
                int idx = binding.getIndex();
                if (idx > parameterCount) {
                    if (Transformer.isVerbose()) {
                        System.out.println("RuleCheckMethodAdapter.checkBindings : found out of range parameter binding " + binding + " checking method " + this.name + this.descriptor);
                    }
                    this.transformContext.warn(this.name, this.descriptor, "found out of range parameter binding " + binding);
                    continue;
                }
                binding.setDescriptor(parameterTypenames.get(idx - 1));
                continue;
            }
            if (binding.isReturn()) {
                LocationType locationType = this.rule.getTargetLocation().getLocationType();
                if (locationType == LocationType.EXIT) {
                    if (!"void".equals(this.getReturnBindingType())) continue;
                    if (Transformer.isVerbose()) {
                        System.out.println("RuleCheckMethodAdapter.checkBindings : found return value binding " + binding + " checking void trigger method " + this.name + this.descriptor + " in AT EXIT rule " + this.rule);
                    }
                    this.transformContext.warn(this.name, this.descriptor, "found return value binding " + binding + " checking void trigger method in AT EXIT rule");
                    continue;
                }
                if (locationType == LocationType.INVOKE_COMPLETED) {
                    if (!"void".equals(this.getReturnBindingType())) continue;
                    if (Transformer.isVerbose()) {
                        System.out.println("RuleCheckMethodAdapter.checkBindings : found return value binding " + binding + " checking void called method in AFTER INVOKE rule  " + this.rule.getName());
                    }
                    this.transformContext.warn(this.name, this.descriptor, "found return value binding " + binding + " checking void called method in AFTER INVOKE rule");
                    continue;
                }
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : found return value binding " + binding + " in rule which is neither AT EXIT nor AFTER INVOKE " + this.rule.getName());
                }
                this.transformContext.warn(this.name, this.descriptor, "found return value binding " + binding + " in rule which is neither AT EXIT nor AFTER INVOKE");
                continue;
            }
            if (binding.isThrowable()) {
                LocationType locationType = this.rule.getTargetLocation().getLocationType();
                if (locationType == LocationType.THROW || locationType == LocationType.EXCEPTION_EXIT) continue;
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : found throwable value binding " + binding + " in rule which is neither AT THROW nor AT EXCEPTION EXIT" + this.rule.getName());
                }
                this.transformContext.warn(this.name, this.descriptor, "found throwable value binding " + binding + " in rule which is not AT THROW");
                continue;
            }
            if (binding.isParamArray() || binding.isParamCount()) continue;
            if (binding.isInvokeParamArray()) {
                if (this.rule.getTargetLocation().getLocationType() == LocationType.INVOKE) continue;
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : found invoke parameter array binding $@ in non-AT INVOKE rule " + this.rule.getName());
                }
                this.transformContext.warn(this.name, this.descriptor, "found throwable value binding " + binding + " in rule which is not AT THROW");
                continue;
            }
            if (binding.isTriggerClass() || binding.isTriggerMethod() || !binding.isLocalVar()) continue;
            String localVarName = binding.getName().substring(1);
            List<RuleMethodAdapter.LocalVar> localVars = this.lookup(localVarName);
            if (localVars == null || localVars.isEmpty()) {
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : unsatisfiable local variable binding " + binding + " checking method " + this.name + this.descriptor);
                }
                this.transformContext.warn(this.name, this.descriptor, "unknown local variable " + binding);
                continue;
            }
            String localDescriptor = null;
            int index = -1;
            Iterator<Label> labelIter = this.triggerPoints.iterator();
            while (labelIter.hasNext()) {
                int triggerPos = labelIter.next().getOffset();
                boolean found = false;
                for (RuleMethodAdapter.LocalVar localVar : localVars) {
                    int start = localVar.start.getOffset();
                    int end = localVar.end.getOffset();
                    if (start > triggerPos || triggerPos >= end) continue;
                    if (localDescriptor == null) {
                        localDescriptor = localVar.desc;
                        index = localVar.index;
                        found = true;
                        break;
                    }
                    if (!localDescriptor.equals(localVar.desc) || index != localVar.index) break;
                    found = true;
                    break;
                }
                if (found) continue;
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : invalid local variable binding " + binding + " checking method " + this.name + this.descriptor);
                }
                this.transformContext.warn(this.name, this.descriptor, "invalid local variable binding " + binding);
                break;
            }
            if (localDescriptor == null) continue;
            binding.setDescriptor(Type.parseFieldDescriptor(localDescriptor));
            binding.setLocalIndex(index);
        }
    }

    @Override
    public void visitEnd() {
        this.checkBindings();
        super.visitEnd();
    }
}

