/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.services.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import shaded.org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;
import shaded.org.hawkular.apm.api.utils.EndpointUtil;

public class CommunicationSummaryTreeBuilder {
    private static final Logger log = Logger.getLogger(CommunicationSummaryTreeBuilder.class.getName());

    public static Collection<CommunicationSummaryStatistics> buildCommunicationSummaryTree(Collection<CommunicationSummaryStatistics> nodes, Set<String> endpoints) {
        HashMap<String, CommunicationSummaryStatistics> nodeMap = new HashMap<String, CommunicationSummaryStatistics>();
        for (CommunicationSummaryStatistics css : nodes) {
            nodeMap.put(css.getId(), css);
        }
        ArrayList<CommunicationSummaryStatistics> ret = new ArrayList<CommunicationSummaryStatistics>();
        for (String endpoint : endpoints) {
            CommunicationSummaryStatistics n = (CommunicationSummaryStatistics)nodeMap.get(EndpointUtil.encodeClientURI(endpoint));
            if (n == null) {
                n = (CommunicationSummaryStatistics)nodeMap.get(endpoint);
            }
            if (n == null) continue;
            CommunicationSummaryStatistics rootNode = new CommunicationSummaryStatistics(n);
            CommunicationSummaryTreeBuilder.initCommunicationSummaryTreeNode(rootNode, nodeMap, new HashSet<String>(Collections.singleton(rootNode.getId())));
            ret.add(rootNode);
        }
        return ret;
    }

    protected static void initCommunicationSummaryTreeNode(CommunicationSummaryStatistics node, Map<String, CommunicationSummaryStatistics> nodeMap, Set<String> usedIds) {
        for (String id : node.getOutbound().keySet()) {
            if (usedIds.contains(id)) continue;
            CommunicationSummaryStatistics orig = nodeMap.get(id);
            CommunicationSummaryStatistics copy = null;
            if (orig == null) {
                log.fine("Node missing for id = " + id + " keySet = " + nodeMap.keySet());
                copy = new CommunicationSummaryStatistics();
                copy.setId(id);
            } else {
                copy = new CommunicationSummaryStatistics(orig);
            }
            CommunicationSummaryStatistics.ConnectionStatistics cs = node.getOutbound().get(id);
            cs.setNode(copy);
            usedIds.add(id);
            CommunicationSummaryTreeBuilder.initCommunicationSummaryTreeNode(copy, nodeMap, usedIds);
        }
    }
}

