/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import shaded.org.hawkular.apm.api.logging.Logger;
import shaded.org.hawkular.apm.api.model.Property;
import shaded.org.hawkular.apm.api.model.trace.ContainerNode;
import shaded.org.hawkular.apm.api.model.trace.Node;

public class NodeUtil {
    private static final Logger log = Logger.getLogger(NodeUtil.class);
    private static final String APM_ORIGINAL_URI = "apm_original_uri";

    @Deprecated
    public static boolean isURIRewritten(Node node) {
        return node.hasProperty(APM_ORIGINAL_URI);
    }

    @Deprecated
    public static void rewriteURI(Node node, String uri) {
        node.getProperties().add(new Property(APM_ORIGINAL_URI, node.getUri()));
        node.setUri(uri);
    }

    @Deprecated
    public static boolean isOriginalURI(Node node, String uri) {
        if (node.getUri().equals(uri)) {
            return true;
        }
        if (node.hasProperty(APM_ORIGINAL_URI)) {
            return node.getProperties(APM_ORIGINAL_URI).iterator().next().getValue().equals(uri);
        }
        return false;
    }

    public static boolean rewriteURI(Node node) {
        boolean processed = false;
        if (node.getUri() != null && node.hasProperty("http.url_template")) {
            String[] uriTokensArray;
            String[] templateTokensArray;
            ArrayList<String> queryParameters = new ArrayList<String>();
            String template = node.getProperties("http.url_template").iterator().next().getValue();
            if (template == null) {
                return false;
            }
            if (template.indexOf(63) != -1) {
                int index = template.indexOf(63);
                String queryString = template.substring(index + 1);
                template = template.substring(0, index);
                StringTokenizer st = new StringTokenizer(queryString, "&");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}') {
                        queryParameters.add(token.substring(1, token.length() - 1));
                        continue;
                    }
                    log.severe("Expecting query parameter template, e.g. {name}, but got '" + token + "'");
                }
            }
            if ((templateTokensArray = template.split("/")).length != (uriTokensArray = node.getUri().split("/", templateTokensArray.length)).length) {
                return false;
            }
            HashSet<Property> props = null;
            for (int i = 1; i < uriTokensArray.length; ++i) {
                String uriToken = uriTokensArray[i];
                String templateToken = templateTokensArray[i];
                if (templateToken.charAt(0) == '{' && templateToken.charAt(templateToken.length() - 1) == '}') {
                    int lastPosition = templateToken.length() - 1;
                    int positionColon = templateToken.indexOf(58);
                    if (positionColon > 0) {
                        lastPosition = positionColon;
                    }
                    String name = templateToken.substring(1, lastPosition);
                    if (props == null) {
                        props = new HashSet<Property>();
                    }
                    try {
                        props.add(new Property(name, URLDecoder.decode(uriToken, "UTF-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!log.isLoggable(Logger.Level.FINEST)) continue;
                        log.finest("Failed to decode value '" + uriToken + "': " + e);
                    }
                    continue;
                }
                if (uriToken.equals(templateToken)) continue;
                return false;
            }
            if (props != null) {
                node.setUri(template);
                node.getProperties().addAll(props);
                processed = true;
            }
            if (NodeUtil.rewriteURIQueryParameters(node, queryParameters)) {
                processed = true;
            }
        }
        return processed;
    }

    private static boolean rewriteURIQueryParameters(Node node, List<String> queryParameters) {
        boolean processed = false;
        if (!queryParameters.isEmpty() && node.hasProperty("http.query")) {
            StringTokenizer st = new StringTokenizer(node.getProperties("http.query").iterator().next().getValue(), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] namevalue = token.split("=");
                if (namevalue.length == 2) {
                    if (queryParameters.contains(namevalue[0])) {
                        try {
                            node.getProperties().add(new Property(URLDecoder.decode(namevalue[0], "UTF-8"), URLDecoder.decode(namevalue[1], "UTF-8")));
                            processed = true;
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isLoggable(Logger.Level.FINEST)) continue;
                            log.finest("Failed to decode value '" + namevalue[1] + "': " + e);
                        }
                        continue;
                    }
                    if (!log.isLoggable(Logger.Level.FINEST)) continue;
                    log.finest("Ignoring query parameter '" + namevalue[0] + "'");
                    continue;
                }
                if (!log.isLoggable(Logger.Level.FINEST)) continue;
                log.finest("Query string part does not include name/value pair: " + token);
            }
        }
        return processed;
    }

    public static <T extends Node> List<T> findNodes(List<Node> nodes, Class<T> cls) {
        ArrayList results = new ArrayList();
        NodeUtil.findNodes(nodes, cls, results);
        return results;
    }

    public static <T extends Node> void findNodes(List<Node> nodes, Class<T> cls, List<T> results) {
        for (Node n : nodes) {
            if (n instanceof ContainerNode) {
                NodeUtil.findNodes(((ContainerNode)n).getNodes(), cls, results);
            }
            if (cls != n.getClass()) continue;
            results.add(n);
        }
    }
}

