/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.internal.actions;

import java.util.List;
import java.util.Map;
import shaded.org.hawkular.apm.api.internal.actions.ExpressionBasedActionHandler;
import shaded.org.hawkular.apm.api.logging.Logger;
import shaded.org.hawkular.apm.api.model.Property;
import shaded.org.hawkular.apm.api.model.Severity;
import shaded.org.hawkular.apm.api.model.config.Direction;
import shaded.org.hawkular.apm.api.model.config.txn.ConfigMessage;
import shaded.org.hawkular.apm.api.model.config.txn.Processor;
import shaded.org.hawkular.apm.api.model.config.txn.ProcessorAction;
import shaded.org.hawkular.apm.api.model.config.txn.SetPropertyAction;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.Trace;

public class SetPropertyActionHandler
extends ExpressionBasedActionHandler {
    private static final Logger log = Logger.getLogger(SetPropertyActionHandler.class);

    public SetPropertyActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public List<ConfigMessage> init(Processor processor) {
        List<ConfigMessage> configMessages = super.init(processor);
        SetPropertyAction action = (SetPropertyAction)this.getAction();
        if (action.getName() == null || action.getName().trim().isEmpty()) {
            String message = "Name must be specified";
            log.severe(processor.getDescription() + ":" + this.getAction().getDescription() + ":" + message);
            ConfigMessage configMessage = new ConfigMessage();
            configMessage.setSeverity(Severity.Error);
            configMessage.setMessage(message);
            configMessage.setField("name");
            configMessage.setProcessor(processor.getDescription());
            configMessage.setAction(action.getDescription());
            configMessages.add(0, configMessage);
        }
        return configMessages;
    }

    @Override
    public boolean process(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(trace, node, direction, headers, values) && (value = this.getValue(trace, node, direction, headers, values)) != null && ((SetPropertyAction)this.getAction()).getName() != null) {
            node.getProperties().add(new Property(((SetPropertyAction)this.getAction()).getName(), value, ((SetPropertyAction)this.getAction()).getType()));
            return true;
        }
        return false;
    }
}

