/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationPageEventMessage
extends PacketImpl {
    private int pageNumber;
    private SimpleString storeName;
    private boolean isDelete;

    public ReplicationPageEventMessage() {
        super((byte)98);
    }

    public ReplicationPageEventMessage(SimpleString storeName, int pageNumber, boolean isDelete) {
        this();
        this.pageNumber = pageNumber;
        this.isDelete = isDelete;
        this.storeName = storeName;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.storeName);
        buffer.writeInt(this.pageNumber);
        buffer.writeBoolean(this.isDelete);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.storeName = buffer.readSimpleString();
        this.pageNumber = buffer.readInt();
        this.isDelete = buffer.readBoolean();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public SimpleString getStoreName() {
        return this.storeName;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public String toString() {
        return ReplicationPageEventMessage.class.getSimpleName() + "(channel=" + this.channelID + ", isDelete=" + this.isDelete + ", storeName=" + this.storeName + ", pageNumber=" + this.pageNumber + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isDelete ? 1231 : 1237);
        result = 31 * result + this.pageNumber;
        result = 31 * result + (this.storeName == null ? 0 : this.storeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReplicationPageEventMessage other = (ReplicationPageEventMessage)((Object)obj);
        if (this.isDelete != other.isDelete) {
            return false;
        }
        if (this.pageNumber != other.pageNumber) {
            return false;
        }
        return !(this.storeName == null ? other.storeName != null : !this.storeName.equals((Object)other.storeName));
    }
}

