/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.agent.opentracing.propagation;

import io.opentracing.propagation.TextMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.apm.api.logging.Logger;

public final class JMSMessageExtractAdapter
implements TextMap {
    private static final Logger log = Logger.getLogger(JMSMessageExtractAdapter.class.getName());
    private final Map<String, String> map = new HashMap<String, String>();

    public JMSMessageExtractAdapter(Object message) {
        try {
            Method getPropertyNames = message.getClass().getMethod("getPropertyNames", new Class[0]);
            Method getStringProperty = message.getClass().getMethod("getStringProperty", String.class);
            Enumeration names = (Enumeration)getPropertyNames.invoke(message, new Object[0]);
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = (String)getStringProperty.invoke(message, name);
                this.map.put(name, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException t) {
            log.log(Logger.Level.WARNING, "Failed to get headers", t);
        }
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public void put(String key, String value) {
        throw new UnsupportedOperationException("JMSMessageExtractAdapter should only be used with Tracer.extract()");
    }
}

