/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.internal.actions;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.AddContentActionHandler;
import org.hawkular.apm.api.internal.actions.AddCorrelationIdActionHandler;
import org.hawkular.apm.api.internal.actions.EvaluateURIActionHandler;
import org.hawkular.apm.api.internal.actions.ProcessorActionHandler;
import org.hawkular.apm.api.internal.actions.SetPropertyActionHandler;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.txn.AddContentAction;
import org.hawkular.apm.api.model.config.txn.AddCorrelationIdAction;
import org.hawkular.apm.api.model.config.txn.EvaluateURIAction;
import org.hawkular.apm.api.model.config.txn.ProcessorAction;
import org.hawkular.apm.api.model.config.txn.SetPropertyAction;

public class ProcessorActionHandlerFactory {
    private static final Logger log = Logger.getLogger(ProcessorActionHandlerFactory.class.getName());
    private static Map<Class<? extends ProcessorAction>, Class<? extends ProcessorActionHandler>> handlers = new HashMap<Class<? extends ProcessorAction>, Class<? extends ProcessorActionHandler>>();

    public static ProcessorActionHandler getHandler(ProcessorAction action) {
        ProcessorActionHandler ret = null;
        Class<? extends ProcessorActionHandler> cls = handlers.get(action.getClass());
        if (cls != null) {
            try {
                Constructor<? extends ProcessorActionHandler> con = cls.getConstructor(ProcessorAction.class);
                ret = con.newInstance(action);
            }
            catch (Exception e) {
                log.log(Logger.Level.SEVERE, "Failed to instantiate handler for action '" + action + "'", e);
            }
        }
        return ret;
    }

    static {
        handlers.put(AddContentAction.class, AddContentActionHandler.class);
        handlers.put(AddCorrelationIdAction.class, AddCorrelationIdActionHandler.class);
        handlers.put(EvaluateURIAction.class, EvaluateURIActionHandler.class);
        handlers.put(SetPropertyAction.class, SetPropertyActionHandler.class);
    }
}

