/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.ApmEvent;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.NodeType;

public class NodeDetails
implements ApmEvent {
    @JsonInclude
    private String id;
    @JsonInclude
    private String traceId;
    @JsonInclude
    private String fragmentId;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean initial = false;
    @JsonInclude
    private String transaction;
    @JsonInclude
    private NodeType type;
    @JsonInclude
    private String uri;
    @JsonInclude
    private long timestamp = 0L;
    @JsonInclude
    private long elapsed = 0L;
    @JsonInclude
    private long actual = 0L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String componentType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String operation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String hostName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String hostAddress;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<Property> properties = new HashSet<Property>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<CorrelationIdentifier> correlationIds = new ArrayList<CorrelationIdentifier>();

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public void setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public void setTransaction(String transaction) {
        this.transaction = transaction;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setType(NodeType type) {
        this.type = type;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(long elapsed) {
        this.elapsed = elapsed;
    }

    public long getActual() {
        return this.actual;
    }

    public void setActual(long actual) {
        this.actual = actual;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<Property> getProperties(String name) {
        HashSet<Property> ret = new HashSet<Property>();
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            ret.add(property);
        }
        return ret;
    }

    public List<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public void setCorrelationIds(List<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.actual ^ this.actual >>> 32);
        result = 31 * result + (this.componentType == null ? 0 : this.componentType.hashCode());
        result = 31 * result + (this.correlationIds == null ? 0 : this.correlationIds.hashCode());
        result = 31 * result + (int)(this.elapsed ^ this.elapsed >>> 32);
        result = 31 * result + (this.fragmentId == null ? 0 : this.fragmentId.hashCode());
        result = 31 * result + (this.hostAddress == null ? 0 : this.hostAddress.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.initial ? 1231 : 1237);
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.traceId == null ? 0 : this.traceId.hashCode());
        result = 31 * result + (this.transaction == null ? 0 : this.transaction.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeDetails other = (NodeDetails)obj;
        if (this.actual != other.actual) {
            return false;
        }
        if (this.componentType == null ? other.componentType != null : !this.componentType.equals(other.componentType)) {
            return false;
        }
        if (this.correlationIds == null ? other.correlationIds != null : !this.correlationIds.equals(other.correlationIds)) {
            return false;
        }
        if (this.elapsed != other.elapsed) {
            return false;
        }
        if (this.fragmentId == null ? other.fragmentId != null : !this.fragmentId.equals(other.fragmentId)) {
            return false;
        }
        if (this.hostAddress == null ? other.hostAddress != null : !this.hostAddress.equals(other.hostAddress)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.initial != other.initial) {
            return false;
        }
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.traceId == null ? other.traceId != null : !this.traceId.equals(other.traceId)) {
            return false;
        }
        if (this.transaction == null ? other.transaction != null : !this.transaction.equals(other.transaction)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "NodeDetails [id=" + this.id + ", traceId=" + this.traceId + ", fragmentId=" + this.fragmentId + ", initial=" + this.initial + ", transaction=" + this.transaction + ", type=" + (Object)((Object)this.type) + ", uri=" + this.uri + ", timestamp=" + this.timestamp + ", elapsed=" + this.elapsed + ", actual=" + this.actual + ", componentType=" + this.componentType + ", operation=" + this.operation + ", hostName=" + this.hostName + ", hostAddress=" + this.hostAddress + ", properties=" + this.properties + ", correlationIds=" + this.correlationIds + "]";
    }
}

