/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.api.recorder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.client.api.recorder.TraceRecorder;

public class LoggingRecorder
implements TraceRecorder {
    private final Logger log;
    private ObjectMapper objectMapper = new ObjectMapper();

    public LoggingRecorder() {
        this(LoggingRecorder.class.getName());
    }

    public LoggingRecorder(String loggerName) {
        this.log = Logger.getLogger(loggerName, true);
    }

    @Override
    public void record(Trace trace) {
        String json;
        if (this.log.isLoggable(Logger.Level.INFO) && (json = this.serialize(trace)) != null) {
            this.log.info(json);
        }
    }

    private String serialize(Object object) {
        String json = null;
        try {
            json = this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.log.severe("Failed to serialize trace", e);
        }
        return json;
    }
}

