/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.opentracing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.trace.Component;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.InteractionNode;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.NodeType;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.api.utils.NodeUtil;

public class NodeBuilder {
    private String uri;
    private String operation;
    private String endpointType = "n/a";
    private String componentType;
    private long duration;
    private Set<Property> properties = new HashSet<Property>();
    private List<CorrelationIdentifier> correlationIds = new ArrayList<CorrelationIdentifier>();
    private List<NodeBuilder> nodes = new ArrayList<NodeBuilder>();
    private long timestamp;
    private NodeType nodeType = NodeType.Component;
    private String nodePath;

    public NodeBuilder() {
    }

    public NodeBuilder(NodeBuilder parent) {
        int pos = parent.addChildNode(this);
        this.nodePath = String.format("%s:%d", parent.getNodePath(), pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addChildNode(NodeBuilder child) {
        List<NodeBuilder> list = this.nodes;
        synchronized (list) {
            this.nodes.add(child);
            return this.nodes.size() - 1;
        }
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public NodeBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public NodeBuilder setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public NodeBuilder setEndpointType(String endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public NodeBuilder setComponentType(String componentType) {
        this.componentType = componentType;
        return this;
    }

    public NodeBuilder setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public NodeBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public NodeBuilder addProperty(Property property) {
        this.properties.add(property);
        return this;
    }

    public NodeBuilder addCorrelationId(CorrelationIdentifier cid) {
        this.correlationIds.add(cid);
        return this;
    }

    public NodeBuilder setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public Node build() {
        InteractionNode ret = null;
        if (this.nodeType == NodeType.Component) {
            ret = new Component();
            ((Component)ret).setComponentType(this.componentType);
        } else if (this.nodeType == NodeType.Consumer) {
            ret = new Consumer();
            ((Consumer)ret).setEndpointType(this.endpointType);
        } else if (this.nodeType == NodeType.Producer) {
            ret = new Producer();
            ((Producer)ret).setEndpointType(this.endpointType);
        }
        ret.setCorrelationIds(this.correlationIds);
        ret.setOperation(this.operation);
        ret.setProperties(this.properties);
        ret.setUri(this.uri);
        ret.setDuration(this.duration);
        ret.setTimestamp(this.timestamp);
        for (int i = 0; i < this.nodes.size(); ++i) {
            ret.getNodes().add(this.nodes.get(i).build());
        }
        NodeUtil.rewriteURI(ret);
        return ret;
    }
}

