/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Arrays2 {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private Arrays2() {
    }

    public static final boolean containsAll(Object[] array, Object ... values) {
        return Arrays.asList(array).containsAll(Arrays.asList(values));
    }

    public static final boolean unorderedEquals(Object[] array, Object ... values) {
        return Arrays2.containsAll(array, values) && array.length == values.length;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... array) {
        HashSet result = new HashSet(array.length);
        Collections.addAll(result, array);
        return result;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays2.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

