/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.agent.opentracing;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.hawkular.apm.api.logging.Logger;
import org.jboss.byteman.agent.Retransformer;

public class OpenTracingRuleLoader {
    private static final Logger log = Logger.getLogger(OpenTracingRuleLoader.class.getName());
    private static final String RULE_FILE_EXTENSION = ".btm";
    private static final String ROOT_RULE_FOLDER = "apmrules";
    private static final String PATH_JAR_SEPARATOR = "!/";
    private static final String FILE_SCHEME = "file:";
    private static Retransformer transformer;

    public static void initialize(Retransformer trans) throws Exception {
        transformer = trans;
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<String> scriptNames = new ArrayList<String>();
        Enumeration<URL> iter = ClassLoader.getSystemResources(ROOT_RULE_FOLDER);
        while (iter.hasMoreElements()) {
            OpenTracingRuleLoader.loadRules(iter.nextElement().toURI(), scriptNames, scripts);
        }
        try (PrintWriter writer = new PrintWriter(new StringWriter());){
            try {
                transformer.installScript(scripts, scriptNames, writer);
            }
            catch (Exception e) {
                log.log(Logger.Level.SEVERE, "Failed to install scripts", e);
            }
        }
        if (log.isLoggable(Logger.Level.FINE)) {
            log.fine("Installed rules");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRules(URI uri, List<String> scriptNames, List<String> scripts) throws IOException {
        if (log.isLoggable(Logger.Level.FINE)) {
            log.fine("Load rules from URI = " + uri);
        }
        FileSystem fs = null;
        String entryName = uri.toString();
        int separator = entryName.indexOf(PATH_JAR_SEPARATOR);
        if (separator != -1) {
            fs = FileSystems.newFileSystem(URI.create(entryName.substring(0, separator)), Collections.emptyMap());
            entryName = entryName.substring(separator + PATH_JAR_SEPARATOR.length());
        } else if (entryName.startsWith(FILE_SCHEME)) {
            fs = FileSystems.getFileSystem(URI.create(FILE_SCHEME + File.separator));
            entryName = entryName.substring(FILE_SCHEME.length());
        }
        if (fs != null) {
            try {
                Path rules = fs.getPath(entryName, new String[0]);
                Files.walk(rules, new FileVisitOption[0]).filter(f -> f.toString().endsWith(RULE_FILE_EXTENSION)).forEach(f -> {
                    try {
                        if (log.isLoggable(Logger.Level.FINE)) {
                            log.fine("Loading rules: " + f.toString());
                        }
                        scripts.add(new String(Files.readAllBytes(f)));
                        scriptNames.add(f.toString());
                    }
                    catch (IOException ioe) {
                        log.log(Logger.Level.SEVERE, "Failed to load rule file: " + f.toString(), ioe);
                    }
                });
            }
            finally {
                if (separator != -1) {
                    fs.close();
                }
            }
        }
    }
}

