/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.analytics;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;
import org.hawkular.apm.api.model.analytics.BuildStamp;

public class ServiceDeployment {
    @JsonInclude
    private final String name;
    @JsonInclude
    private final List<BuildStamp> buildStamps;

    public ServiceDeployment(String name, List<BuildStamp> buildStamps) {
        if (null == name || name.isEmpty()) {
            throw new IllegalStateException("The service name cannot be null nor empty.");
        }
        if (null == buildStamps) {
            buildStamps = Collections.emptyList();
        }
        this.name = name;
        this.buildStamps = buildStamps;
    }

    public String getName() {
        return this.name;
    }

    public List<BuildStamp> getBuildStamps() {
        return this.buildStamps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDeployment that = (ServiceDeployment)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.buildStamps.equals(that.buildStamps);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.buildStamps.hashCode();
        return result;
    }

    public String toString() {
        return "ServiceDeployment{name='" + this.name + '\'' + ", buildStamps=" + this.buildStamps + '}';
    }
}

