/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.opentracing;

import io.opentracing.impl.APMSpan;
import java.util.Map;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.client.opentracing.NodeBuilder;
import org.hawkular.apm.client.opentracing.NodeProcessor;
import org.hawkular.apm.client.opentracing.TagUtil;
import org.hawkular.apm.client.opentracing.TraceContext;

public class DefaultNodeProcessor
implements NodeProcessor {
    @Override
    public void process(TraceContext context, APMSpan span, NodeBuilder nodeBuilder) {
        for (Map.Entry<String, Object> entry : span.getTags().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (TagUtil.isUriKey(entry.getKey())) {
                nodeBuilder.setUri(TagUtil.getUriPath(entry.getValue().toString()));
                String type = TagUtil.getTypeFromUriKey(entry.getKey());
                nodeBuilder.setEndpointType(type);
                nodeBuilder.setComponentType(type);
                continue;
            }
            if (entry.getKey().equals("component")) {
                nodeBuilder.setComponentType(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().contains("transaction")) {
                if (context.getTransaction() != null) continue;
                context.setTransaction(entry.getValue().toString());
                continue;
            }
            nodeBuilder.addProperty(new Property(entry.getKey(), entry.getValue()));
        }
    }
}

