/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.trace.publisher.rest.client;

import java.time.Clock;
import java.util.List;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.PublisherMetricHandler;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.client.api.rest.AbstractRESTClient;

public class TracePublisherRESTClient
extends AbstractRESTClient
implements TracePublisher {
    private static final Logger log = Logger.getLogger(TracePublisherRESTClient.class.getName());
    private PublisherMetricHandler<Trace> handler = null;
    private Clock clock = Clock.systemUTC();

    public TracePublisherRESTClient() {
        super("HAWKULAR_APM_URI_PUBLISHER");
    }

    public TracePublisherRESTClient(String username, String password, String url) {
        super(username, password, url);
    }

    @Override
    public int getInitialRetryCount() {
        return 0;
    }

    @Override
    public void publish(String tenantId, List<Trace> traces) throws Exception {
        long startTime = this.clock.millis();
        int statusCode = this.postAsJsonTo(tenantId, "traces/fragments", traces);
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Status code is: " + statusCode);
        }
        if (this.handler != null) {
            this.handler.published(tenantId, traces, this.clock.millis() - startTime);
        }
        if (statusCode != 204) {
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Failed to publish trace fragments: status=[" + statusCode + "]");
            }
            throw new Exception("Failed to publish trace fragments: status=[" + statusCode + "]");
        }
    }

    @Override
    public void publish(String tenantId, List<Trace> items, int retryCount, long delay) throws Exception {
        throw new UnsupportedOperationException("Cannot set the retry count and delay");
    }

    @Override
    public void retry(String tenantId, List<Trace> items, String subscriber, int retryCount, long delay) throws Exception {
        throw new UnsupportedOperationException("Cannot retry");
    }

    @Override
    public void setMetricHandler(PublisherMetricHandler<Trace> handler) {
        this.handler = handler;
    }
}

