/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.internal.actions;

import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.ExpressionHandler;
import org.hawkular.apm.api.internal.actions.ExpressionHandlerFactory;
import org.hawkular.apm.api.internal.actions.ProcessorActionHandler;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.Severity;
import org.hawkular.apm.api.model.config.Direction;
import org.hawkular.apm.api.model.config.txn.ConfigMessage;
import org.hawkular.apm.api.model.config.txn.ExpressionBasedAction;
import org.hawkular.apm.api.model.config.txn.Processor;
import org.hawkular.apm.api.model.config.txn.ProcessorAction;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;

public abstract class ExpressionBasedActionHandler
extends ProcessorActionHandler {
    private static final Logger log = Logger.getLogger(ExpressionBasedActionHandler.class.getName());
    private ExpressionHandler expression = null;

    public ExpressionBasedActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public List<ConfigMessage> init(Processor processor) {
        List<ConfigMessage> configMessages = super.init(processor);
        if (((ExpressionBasedAction)this.getAction()).getExpression() != null) {
            try {
                this.expression = ExpressionHandlerFactory.getHandler(((ExpressionBasedAction)this.getAction()).getExpression());
                this.expression.init(processor, this.getAction(), false);
                if (!this.isUsesHeaders()) {
                    this.setUsesHeaders(this.expression.isUsesHeaders());
                }
                if (!this.isUsesContent()) {
                    this.setUsesContent(this.expression.isUsesContent());
                }
            }
            catch (Throwable t) {
                log.severe(processor.getDescription() + ":" + this.getAction().getDescription() + ":Failed to compile expression");
                ConfigMessage configMessage = new ConfigMessage();
                configMessage.setSeverity(Severity.Error);
                configMessage.setMessage(t.getMessage());
                configMessage.setField("expression");
                configMessage.setProcessor(processor.getDescription());
                configMessage.setAction(this.getAction().getDescription());
                configMessages.add(configMessage);
            }
        } else {
            String message = "Expression has not been defined";
            log.severe(processor.getDescription() + ":" + this.getAction().getDescription() + ":" + message);
            ConfigMessage configMessage = new ConfigMessage();
            configMessage.setSeverity(Severity.Error);
            configMessage.setMessage(message);
            configMessage.setField("expression");
            configMessage.setProcessor(processor.getDescription());
            configMessage.setAction(this.getAction().getDescription());
            configMessages.add(configMessage);
        }
        return configMessages;
    }

    protected String getValue(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.expression != null) {
            return this.expression.evaluate(trace, node, direction, headers, values);
        }
        return null;
    }
}

