/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.internal.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.ExpressionHandler;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.Severity;
import org.hawkular.apm.api.model.config.Direction;
import org.hawkular.apm.api.model.config.txn.ConfigMessage;
import org.hawkular.apm.api.model.config.txn.Expression;
import org.hawkular.apm.api.model.config.txn.LiteralExpression;
import org.hawkular.apm.api.model.config.txn.Processor;
import org.hawkular.apm.api.model.config.txn.ProcessorAction;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;

public class LiteralExpressionHandler
extends ExpressionHandler {
    private static final Logger log = Logger.getLogger(LiteralExpressionHandler.class);
    private boolean predicateResult = false;

    public LiteralExpressionHandler(Expression expression) {
        super(expression);
    }

    @Override
    public List<ConfigMessage> init(Processor processor, ProcessorAction action, boolean predicate) {
        ArrayList<ConfigMessage> configMessages = new ArrayList<ConfigMessage>();
        if (predicate) {
            LiteralExpression expr = (LiteralExpression)this.getExpression();
            if (!expr.getValue().equalsIgnoreCase("true") && !expr.getValue().equalsIgnoreCase("false")) {
                String message = "Literal expression must have a boolean (true/false) value when used as a predicate";
                log.severe(processor.getDescription() + ":" + action.getDescription() + ":" + message);
                ConfigMessage configMessage = new ConfigMessage();
                configMessage.setSeverity(Severity.Error);
                configMessage.setMessage(message);
                configMessage.setProcessor(processor.getDescription());
                configMessage.setAction(action.getDescription());
                configMessages.add(configMessage);
            } else {
                this.predicateResult = new Boolean(((LiteralExpression)this.getExpression()).getValue());
            }
        }
        return configMessages;
    }

    @Override
    public boolean test(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        return this.predicateResult;
    }

    @Override
    public String evaluate(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        return ((LiteralExpression)this.getExpression()).getValue();
    }
}

