/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.CollectorConfiguration;
import org.hawkular.apm.api.utils.PropertyUtil;

public class ConfigurationLoader {
    private static final String DEFAULT_TYPE = "jvm";
    public static final String HAWKULAR_APM_CONFIG = "HAWKULAR_APM_CONFIG";
    private static final String DEFAULT_URI = "apmconfig";
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = Logger.getLogger(ConfigurationLoader.class.getName());

    public static CollectorConfiguration getConfiguration(String type) {
        return ConfigurationLoader.loadConfig(PropertyUtil.getProperty(HAWKULAR_APM_CONFIG, DEFAULT_URI), type);
    }

    protected static CollectorConfiguration loadConfig(String uri, String type) {
        File f;
        final CollectorConfiguration config = new CollectorConfiguration();
        if (type == null) {
            type = DEFAULT_TYPE;
        }
        if (!(f = new File(uri = uri + File.separator + type)).isAbsolute()) {
            if (f.exists()) {
                uri = f.getAbsolutePath();
            } else if (System.getProperties().containsKey("jboss.server.config.dir")) {
                uri = System.getProperty("jboss.server.config.dir") + File.separatorChar + uri;
            } else {
                try {
                    URL url = Thread.currentThread().getContextClassLoader().getResource(uri);
                    if (url != null) {
                        uri = url.getPath();
                    } else {
                        log.severe("Failed to get absolute path for uri '" + uri + "'");
                    }
                }
                catch (Exception e) {
                    log.log(Logger.Level.SEVERE, "Failed to get absolute path for uri '" + uri + "'", e);
                    uri = null;
                }
            }
        }
        if (uri != null) {
            String[] uriParts = uri.split(Matcher.quoteReplacement(File.separator));
            int startIndex = 0;
            if (uriParts[0].equals("file:")) {
                ++startIndex;
            }
            try {
                Path path = ConfigurationLoader.getPath(startIndex, uriParts);
                Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (path.toString().endsWith(".json")) {
                            String json = new String(Files.readAllBytes(path));
                            CollectorConfiguration childConfig = mapper.readValue(json, CollectorConfiguration.class);
                            if (childConfig != null) {
                                config.merge(childConfig, false);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Throwable e) {
                log.log(Logger.Level.SEVERE, "Failed to load configuration", e);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Path getPath(int startindex, String[] uriParts) {
        Path ret = Paths.get("/", new String[0]);
        ArrayList toClose = new ArrayList();
        try {
            for (int i = startindex; i < uriParts.length; ++i) {
                String name = uriParts[i];
                if (name.endsWith("!")) {
                    name = name.substring(0, name.length() - 1);
                }
                ret = ret.resolve(name);
                if (!name.endsWith(".jar") && !name.endsWith(".war")) continue;
                try (FileSystem jarfs = FileSystems.newFileSystem(ret, Thread.currentThread().getContextClassLoader());){
                    ret = jarfs.getRootDirectories().iterator().next();
                    continue;
                }
                catch (IOException e) {
                    log.log(Logger.Level.SEVERE, "Failed to access archive '" + name + "'", e);
                }
            }
        }
        finally {
            for (FileSystem fs : toClose) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    log.log(Logger.Level.SEVERE, "Failed to close file system '" + fs + "'", e);
                }
            }
        }
        return ret;
    }
}

