/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.thread.pool;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jberet.spi.JobExecutor;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.ManagedJBossThreadPoolExecutorService;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.UnboundedQueueThreadPoolAdd;
import org.jboss.as.threads.UnboundedQueueThreadPoolMetricsHandler;
import org.jboss.as.threads.UnboundedQueueThreadPoolRemove;
import org.jboss.as.threads.UnboundedQueueThreadPoolWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.BatchServiceNames;
import org.wildfly.extension.batch.jberet._private.Capabilities;
import org.wildfly.extension.batch.jberet.impl.JobExecutorService;

public class BatchThreadPoolResourceDefinition
extends SimpleResourceDefinition {
    public static final String NAME = "thread-pool";
    static final PathElement PATH = PathElement.pathElement((String)"thread-pool");
    private final boolean registerRuntimeOnly;

    public BatchThreadPoolResourceDefinition(boolean registerRuntimeOnly) {
        super(PATH, (ResourceDescriptionResolver)BatchThreadPoolDescriptionResolver.INSTANCE, (OperationStepHandler)BatchThreadPoolAdd.INSTANCE, (OperationStepHandler)BatchThreadPoolRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PoolAttributeDefinitions.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        new UnboundedQueueThreadPoolWriteAttributeHandler(BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME).registerAttributes(resourceRegistration);
        if (this.registerRuntimeOnly) {
            new UnboundedQueueThreadPoolMetricsHandler(BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME).registerAttributes(resourceRegistration);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(Capabilities.THREAD_POOL_CAPABILITY);
    }

    private static class BatchThreadPoolDescriptionResolver
    implements ResourceDescriptionResolver {
        static final BatchThreadPoolDescriptionResolver INSTANCE = new BatchThreadPoolDescriptionResolver();
        private static final Set<String> COMMON_ATTRIBUTE_NAMES = Stream.of(PoolAttributeDefinitions.ACTIVE_COUNT.getName(), PoolAttributeDefinitions.COMPLETED_TASK_COUNT.getName(), PoolAttributeDefinitions.CURRENT_THREAD_COUNT.getName(), "keepalive-time", PoolAttributeDefinitions.LARGEST_THREAD_COUNT.getName(), PoolAttributeDefinitions.MAX_THREADS.getName(), PoolAttributeDefinitions.NAME.getName(), PoolAttributeDefinitions.QUEUE_SIZE.getName(), PoolAttributeDefinitions.TASK_COUNT.getName(), PoolAttributeDefinitions.THREAD_FACTORY.getName()).collect(Collectors.toSet());
        private static final String COMMON_PREFIX = "threadpool.common";
        private final StandardResourceDescriptionResolver delegate = BatchResourceDescriptionResolver.getResourceDescriptionResolver("thread-pool");

        private BatchThreadPoolDescriptionResolver() {
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return this.delegate.getResourceBundle(locale);
        }

        public String getResourceDescription(Locale locale, ResourceBundle bundle) {
            return this.delegate.getResourceDescription(locale, bundle);
        }

        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
            if (COMMON_ATTRIBUTE_NAMES.contains(attributeName)) {
                return bundle.getString(this.getKey(attributeName));
            }
            return this.delegate.getResourceAttributeDescription(attributeName, locale, bundle);
        }

        public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.contains(attributeName)) {
                return bundle.getString(this.getVariableBundleKey(new String[]{attributeName}, suffixes));
            }
            return this.delegate.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
        }

        public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle) {
            return this.delegate.getOperationDescription(operationName, locale, bundle);
        }

        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
            if ("add".equals(operationName) && COMMON_ATTRIBUTE_NAMES.contains(paramName)) {
                return bundle.getString(this.getKey(paramName));
            }
            return this.delegate.getOperationParameterDescription(operationName, paramName, locale, bundle);
        }

        public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
            if ("add".equals(operationName) && COMMON_ATTRIBUTE_NAMES.contains(paramName)) {
                return bundle.getString(this.getVariableBundleKey(new String[]{paramName}, suffixes));
            }
            return this.delegate.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
        }

        public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle) {
            return this.delegate.getOperationReplyDescription(operationName, locale, bundle);
        }

        public String getOperationReplyValueTypeDescription(String operationName, Locale locale, ResourceBundle bundle, String ... suffixes) {
            return this.delegate.getOperationReplyValueTypeDescription(operationName, locale, bundle, suffixes);
        }

        public String getNotificationDescription(String notificationType, Locale locale, ResourceBundle bundle) {
            return this.delegate.getNotificationDescription(notificationType, locale, bundle);
        }

        public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle) {
            return this.delegate.getChildTypeDescription(childType, locale, bundle);
        }

        public String getResourceDeprecatedDescription(Locale locale, ResourceBundle bundle) {
            return this.delegate.getResourceDeprecatedDescription(locale, bundle);
        }

        public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle) {
            return this.delegate.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle);
        }

        public String getOperationDeprecatedDescription(String operationName, Locale locale, ResourceBundle bundle) {
            return this.delegate.getOperationDeprecatedDescription(operationName, locale, bundle);
        }

        public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
            return this.delegate.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle);
        }

        private String getKey(String ... args) {
            return this.getVariableBundleKey(args, new String[0]);
        }

        private String getVariableBundleKey(String[] fixed, String ... variable) {
            StringBuilder sb = new StringBuilder(COMMON_PREFIX);
            for (String arg : fixed) {
                sb.append('.');
                sb.append(arg);
            }
            if (variable != null) {
                for (String arg : variable) {
                    sb.append('.');
                    sb.append(arg);
                }
            }
            return sb.toString();
        }
    }

    private static class BatchThreadFactoryResolver
    extends ThreadFactoryResolver.SimpleResolver {
        static final BatchThreadFactoryResolver INSTANCE = new BatchThreadFactoryResolver();

        private BatchThreadFactoryResolver() {
            super(ThreadsServices.FACTORY);
        }

        protected String getThreadGroupName(String threadPoolName) {
            return "Batch Thread";
        }
    }

    static class BatchThreadPoolRemove
    extends UnboundedQueueThreadPoolRemove {
        static final BatchThreadPoolRemove INSTANCE = new BatchThreadPoolRemove();

        public BatchThreadPoolRemove() {
            super((UnboundedQueueThreadPoolAdd)BatchThreadPoolAdd.INSTANCE);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            context.removeService(context.getCapabilityServiceName(Capabilities.THREAD_POOL_CAPABILITY.getName(), context.getCurrentAddressValue(), null));
            super.performRuntime(context, operation, model);
        }
    }

    static class BatchThreadPoolAdd
    extends UnboundedQueueThreadPoolAdd {
        static final BatchThreadPoolAdd INSTANCE = new BatchThreadPoolAdd((ThreadFactoryResolver)BatchThreadFactoryResolver.INSTANCE, BatchServiceNames.BASE_BATCH_THREAD_POOL_NAME);
        private final ServiceName serviceNameBase;

        public BatchThreadPoolAdd(ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase) {
            super(threadFactoryResolver, serviceNameBase);
            this.serviceNameBase = serviceNameBase;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String name = context.getCurrentAddressValue();
            ServiceTarget target = context.getServiceTarget();
            JobExecutorService service = new JobExecutorService();
            ServiceBuilder serviceBuilder = target.addService(context.getCapabilityServiceName(Capabilities.THREAD_POOL_CAPABILITY.getName(), name, JobExecutor.class), (Service)service);
            serviceBuilder.addDependency(this.serviceNameBase.append(new String[]{name}), ManagedJBossThreadPoolExecutorService.class, service.getThreadPoolInjector());
            serviceBuilder.install();
        }
    }
}

