/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Timer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMetadataResolver
extends AbstractReloadingMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(HTTPMetadataResolver.class);
    private HttpClient httpClient;
    private URI metadataURI;
    private String cachedMetadataETag;
    private String cachedMetadataLastModified;
    private BasicCredentialsProvider credentialsProvider;
    private TrustEngine<? super X509Credential> tlsTrustEngine;

    public HTTPMetadataResolver(HttpClient client, String metadataURL) throws ResolverException {
        this(null, client, metadataURL);
    }

    public HTTPMetadataResolver(Timer backgroundTaskTimer, HttpClient client, String metadataURL) throws ResolverException {
        super(backgroundTaskTimer);
        if (client == null) {
            throw new ResolverException("HTTP client may not be null");
        }
        this.httpClient = client;
        try {
            this.metadataURI = new URI(metadataURL);
        }
        catch (URISyntaxException e) {
            throw new ResolverException("Illegal URL syntax", (Exception)e);
        }
    }

    public String getMetadataURI() {
        return this.metadataURI.toASCIIString();
    }

    public void setTLSTrustEngine(@Nullable TrustEngine<? super X509Credential> engine) {
        this.tlsTrustEngine = engine;
    }

    public void setBasicCredentials(@Nullable UsernamePasswordCredentials credentials) {
        this.setBasicCredentialsWithScope(credentials, null);
    }

    public void setBasicCredentialsWithScope(@Nullable UsernamePasswordCredentials credentials, @Nullable AuthScope scope) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (credentials != null) {
            AuthScope authScope = scope;
            if (authScope == null) {
                authScope = new AuthScope(this.metadataURI.getHost(), this.metadataURI.getPort());
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(authScope, (Credentials)credentials);
            this.credentialsProvider = provider;
        } else {
            this.log.debug("Either username or password were null, disabling basic auth");
            this.credentialsProvider = null;
        }
    }

    @Override
    protected void doDestroy() {
        this.httpClient = null;
        this.credentialsProvider = null;
        this.metadataURI = null;
        this.cachedMetadataETag = null;
        this.cachedMetadataLastModified = null;
        super.doDestroy();
    }

    @Override
    protected String getMetadataIdentifier() {
        return this.metadataURI.toString();
    }

    @Override
    protected byte[] fetchMetadata() throws ResolverException {
        HttpGet httpGet = this.buildHttpGet();
        HttpClientContext context = this.buildHttpClientContext();
        HttpResponse response = null;
        try {
            this.log.debug("Attempting to fetch metadata document from '{}'", (Object)this.metadataURI);
            response = this.httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);
            this.checkTLSCredentialTrusted(context);
            int httpStatusCode = response.getStatusLine().getStatusCode();
            if (httpStatusCode == 304) {
                this.log.debug("Metadata document from '{}' has not changed since last retrieval", (Object)this.getMetadataURI());
                byte[] byArray = null;
                return byArray;
            }
            if (httpStatusCode != 200) {
                String errMsg = "Non-ok status code " + httpStatusCode + " returned from remote metadata source " + this.metadataURI;
                this.log.error(errMsg);
                throw new ResolverException(errMsg);
            }
            this.processConditionalRetrievalHeaders(response);
            byte[] rawMetadata = this.getMetadataBytesFromResponse(response);
            this.log.debug("Successfully fetched {} bytes of metadata from {}", (Object)rawMetadata.length, (Object)this.getMetadataURI());
            byte[] byArray = rawMetadata;
            return byArray;
        }
        catch (IOException e) {
            String errMsg = "Error retrieving metadata from " + this.metadataURI;
            this.log.error(errMsg, (Throwable)e);
            throw new ResolverException(errMsg, (Exception)e);
        }
        finally {
            try {
                if (response != null && response instanceof CloseableHttpResponse) {
                    ((CloseableHttpResponse)response).close();
                }
            }
            catch (IOException e) {
                this.log.error("Error closing HTTP response from {}", (Object)this.metadataURI, (Object)e);
            }
        }
    }

    protected void checkTLSCredentialTrusted(HttpClientContext context) throws SSLPeerUnverifiedException {
        if (this.tlsTrustEngine != null && "https".equalsIgnoreCase(this.metadataURI.getScheme()) && context.getAttribute("opensaml.ServerTLSCredentialTrusted") == null) {
            this.log.warn("Configured TLS trust engine was not used to verify server TLS credential, the appropriate socket factory was likely not configured");
            throw new SSLPeerUnverifiedException("Evaluation of server TLS credential with configured TrustEngine was not performed");
        }
    }

    protected HttpGet buildHttpGet() {
        HttpGet getMethod = new HttpGet(this.getMetadataURI());
        if (this.cachedMetadataETag != null) {
            getMethod.setHeader("If-None-Match", this.cachedMetadataETag);
        }
        if (this.cachedMetadataLastModified != null) {
            getMethod.setHeader("If-Modified-Since", this.cachedMetadataLastModified);
        }
        return getMethod;
    }

    protected HttpClientContext buildHttpClientContext() {
        HttpClientContext context = HttpClientContext.create();
        if (this.credentialsProvider != null) {
            context.setCredentialsProvider((CredentialsProvider)this.credentialsProvider);
        }
        if (this.tlsTrustEngine != null) {
            context.setAttribute("opensaml.TrustEngine", this.tlsTrustEngine);
        }
        return context;
    }

    protected void processConditionalRetrievalHeaders(HttpResponse response) {
        Header httpHeader = response.getFirstHeader("ETag");
        if (httpHeader != null) {
            this.cachedMetadataETag = httpHeader.getValue();
        }
        if ((httpHeader = response.getFirstHeader("Last-Modified")) != null) {
            this.cachedMetadataLastModified = httpHeader.getValue();
        }
    }

    protected byte[] getMetadataBytesFromResponse(HttpResponse response) throws ResolverException {
        this.log.debug("Attempting to extract metadata from response to request for metadata from '{}'", (Object)this.getMetadataURI());
        try {
            InputStream ins = response.getEntity().getContent();
            byte[] byArray = this.inputstreamToByteArray(ins);
            return byArray;
        }
        catch (IOException e) {
            this.log.error("Unable to read response", (Throwable)e);
            throw new ResolverException("Unable to read response", (Exception)e);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }
}

