/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.utils;

import shaded.org.hawkular.apm.api.model.events.EndpointRef;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.Producer;
import shaded.org.hawkular.apm.api.model.trace.Trace;

public class EndpointUtil {
    public static String encodeEndpoint(String uri, String operation) {
        StringBuilder buf = new StringBuilder();
        if (uri != null && !uri.trim().isEmpty()) {
            buf.append(uri);
        }
        if (operation != null && !operation.trim().isEmpty()) {
            buf.append('[');
            buf.append(operation);
            buf.append(']');
        }
        return buf.toString();
    }

    public static String decodeEndpointURI(String endpoint) {
        int ind = endpoint.indexOf(91);
        if (ind == 0) {
            return null;
        }
        if (ind != -1) {
            return endpoint.substring(0, ind);
        }
        return endpoint;
    }

    public static String decodeEndpointOperation(String endpoint, boolean stripped) {
        int ind = endpoint.indexOf(91);
        if (ind != -1) {
            if (stripped) {
                return endpoint.substring(ind + 1, endpoint.length() - 1);
            }
            return endpoint.substring(ind);
        }
        return null;
    }

    public static String encodeClientURI(String uri) {
        if (uri == null) {
            return "client:";
        }
        return "client:" + uri;
    }

    public static String decodeClientURI(String clientUri) {
        return clientUri.startsWith("client:") ? clientUri.substring("client:".length()) : clientUri;
    }

    public static EndpointRef getSourceEndpoint(Trace fragment) {
        Node rootNode;
        Node node = rootNode = fragment.getNodes().isEmpty() ? null : fragment.getNodes().get(0);
        if (rootNode == null) {
            return null;
        }
        return new EndpointRef(rootNode.getUri(), rootNode.getOperation(), fragment.initialFragment() && rootNode instanceof Producer);
    }
}

