/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.BatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;

public class DefaultCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private static final ThreadLocal<Batch> CURRENT_BATCH = new ThreadLocal();
    private final EmbeddedCacheManager manager;
    private final Batcher<? extends Batch> batcher;
    private final Set<Flag> flags;

    DefaultCache(final EmbeddedCacheManager manager, final Batcher<? extends Batch> batcher, AdvancedCache<K, V> cache, final Set<Flag> flags) {
        super(cache, new AbstractDelegatingAdvancedCache.AdvancedCacheWrapper<K, V>(){

            public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                return new DefaultCache(manager, (Batcher<? extends Batch>)batcher, cache, flags);
            }
        });
        this.manager = manager;
        this.batcher = batcher;
        this.flags = flags;
    }

    public DefaultCache(EmbeddedCacheManager manager, BatcherFactory batcherFactory, AdvancedCache<K, V> cache) {
        this(manager, batcherFactory.createBatcher((Cache<?, ?>)cache), cache, EnumSet.noneOf(Flag.class));
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public boolean startBatch() {
        if (this.batcher == null) {
            return false;
        }
        if (CURRENT_BATCH.get() != null) {
            return false;
        }
        CURRENT_BATCH.set(this.batcher.createBatch());
        return true;
    }

    public void endBatch(boolean successful) {
        Batch batch = CURRENT_BATCH.get();
        if (batch != null) {
            try {
                if (successful) {
                    batch.close();
                } else {
                    batch.discard();
                }
            }
            finally {
                CURRENT_BATCH.remove();
            }
        }
    }

    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        EnumSet<Flag> set = EnumSet.copyOf(this.flags);
        set.addAll(Arrays.asList(flags));
        return new DefaultCache<K, V>(this.manager, this.batcher, this.cache.withFlags(flags), set);
    }

    public boolean equals(Object object) {
        return object == this || object == this.cache;
    }

    public int hashCode() {
        return this.cache.hashCode();
    }
}

