/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.dto;

import java.io.File;
import java.net.URI;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="server")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServerDTO {
    @XmlAttribute
    public String configuration;
    private File configurationFile;
    private URI configurationURI;

    public URI getConfigurationURI() throws Exception {
        if (this.configurationURI == null) {
            this.configurationURI = new URI(ServerDTO.fixupFileURI(this.configuration));
        }
        return this.configurationURI;
    }

    public File getConfigurationFile() throws Exception {
        if (this.configurationFile == null) {
            this.configurationFile = new File(new URI(ServerDTO.fixupFileURI(this.configuration)).getSchemeSpecificPart());
        }
        return this.configurationFile;
    }

    private static String fixupFileURI(String value) {
        if (value != null && value.startsWith("file:")) {
            value = value.substring("file:".length());
            value = new File(value).toURI().toString();
        }
        return value;
    }
}

