/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.utils;

import org.hawkular.apm.api.model.trace.Node;

public class NodeUtil {
    private static final String APM_ORIGINAL_URI = "apm_original_uri";

    public static boolean isURIRewritten(Node node) {
        return node.getDetails().containsKey(APM_ORIGINAL_URI);
    }

    public static void rewriteURI(Node node, String uri) {
        node.getDetails().put(APM_ORIGINAL_URI, node.getUri());
        node.setUri(uri);
    }

    public static boolean isOriginalURI(Node node, String uri) {
        if (node.getUri().equals(uri)) {
            return true;
        }
        String original = node.getDetails().get(APM_ORIGINAL_URI);
        if (original != null) {
            return original.equals(uri);
        }
        return false;
    }
}

