/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.utils;

import org.hawkular.apm.api.logging.Logger;

public class PropertyUtil {
    private static final Logger LOG = Logger.getLogger(PropertyUtil.class.getName());
    public static final String HAWKULAR_TENANT = "HAWKULAR_TENANT";
    public static final String HAWKULAR_APM_URI = "HAWKULAR_APM_URI";
    public static final String HAWKULAR_APM_USERNAME = "HAWKULAR_APM_USERNAME";
    public static final String HAWKULAR_APM_PASSWORD = "HAWKULAR_APM_PASSWORD";
    public static final String HAWKULAR_APM_CONFIG_REFRESH = "HAWKULAR_APM_CONFIG_REFRESH";
    public static final String HAWKULAR_APM_LOG_LEVEL = "HAWKULAR_APM_LOG_LEVEL";
    public static final String HAWKULAR_APM_LOG_JUL = "HAWKULAR_APM_LOG_JUL";
    public static final String HAWKULAR_APM_COLLECTOR_BATCHSIZE = "HAWKULAR_APM_COLLECTOR_BATCHSIZE";
    public static final String HAWKULAR_APM_COLLECTOR_BATCHTIME = "HAWKULAR_APM_COLLECTOR_BATCHTIME";
    public static final String HAWKULAR_APM_COLLECTOR_BATCHTHREADS = "HAWKULAR_APM_COLLECTOR_BATCHTHREADS";
    public static final String HAWKULAR_APM_PROCESSOR_MAX_RETRY_COUNT = "HAWKULAR_APM_PROCESSOR_MAX_RETRY_COUNT";
    public static final String HAWKULAR_APM_PROCESSOR_RETRY_DELAY = "HAWKULAR_APM_PROCESSOR_RETRY_DELAY";
    public static final String HAWKULAR_APM_PROCESSOR_LAST_RETRY_DELAY = "HAWKULAR_APM_PROCESSOR_LAST_RETRY_DELAY";

    public static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    public static String getProperty(String name, String def) {
        String ret = System.getProperty(name, System.getenv(name));
        if (ret != null) {
            return ret;
        }
        return def;
    }

    public static Integer getPropertyAsInteger(String name) {
        return PropertyUtil.getPropertyAsInteger(name, null);
    }

    public static Integer getPropertyAsInteger(String name, Integer def) {
        String value = PropertyUtil.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.log(Logger.Level.WARNING, "Failed to convert property value '" + value + "' to integer", e);
            }
        }
        return def;
    }

    public static boolean getPropertyAsBoolean(String name) {
        String value = PropertyUtil.getProperty(name);
        return value != null && value.equalsIgnoreCase("true");
    }
}

