/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.collector.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.ReportingLevel;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.utils.NodeUtil;

public class FragmentBuilder {
    private static final Logger log = Logger.getLogger(FragmentBuilder.class.getName());
    private Trace trace;
    private Stack<Node> nodeStack = new Stack();
    private Stack<Node> poppedNodes = new Stack();
    private Stack<Node> suppressedNodeStack = new Stack();
    private Map<String, Node> retainedNodes = new HashMap<String, Node>();
    private List<Node> ignoredNodes = new ArrayList<Node>();
    private Map<String, NodePlaceholder> uncompletedCorrelationIdsNodeMap = new HashMap<String, NodePlaceholder>();
    private Map<String, StateInformation> stateInformation = new HashMap<String, StateInformation>();
    private boolean suppress = false;
    private static String hostName;
    private static String hostAddress;
    private ReportingLevel level = ReportingLevel.All;
    private int inHashCode = 0;
    private ByteArrayOutputStream inStream = null;
    private int outHashCode = 0;
    private ByteArrayOutputStream outStream = null;
    private AtomicInteger threadCount = new AtomicInteger();

    public FragmentBuilder() {
        this.trace = new Trace().setId(UUID.randomUUID().toString()).setStartTime(System.currentTimeMillis()).setHostName(hostName).setHostAddress(hostAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            return this.nodeStack.isEmpty() && this.retainedNodes.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleteExceptIgnoredNodes() {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            int i;
            if (this.nodeStack.isEmpty() && this.retainedNodes.isEmpty()) {
                return true;
            }
            for (i = 0; i < this.nodeStack.size(); ++i) {
                if (this.ignoredNodes.contains(this.nodeStack.get(i))) continue;
                return false;
            }
            for (i = 0; i < this.retainedNodes.size(); ++i) {
                if (this.ignoredNodes.contains(this.retainedNodes.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public Trace getTrace() {
        return this.trace;
    }

    public ReportingLevel getLevel() {
        return this.level;
    }

    public void setLevel(ReportingLevel level) {
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getCurrentNode() {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            return this.nodeStack.isEmpty() ? null : this.nodeStack.peek();
        }
    }

    protected Stack<Node> getNodeStack() {
        return this.nodeStack;
    }

    protected Stack<Node> getPoppedNodes() {
        return this.poppedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getLatestNode(String nodeType, boolean onStack) {
        Node node = null;
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            Stack<Node> stack2 = onStack ? this.nodeStack : this.poppedNodes;
            for (int i = 0; node == null && i < stack2.size(); ++i) {
                Node n = (Node)stack2.elementAt(i);
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Get latest node: checking node type '" + nodeType + "' against '" + n.getClass().getSimpleName() + "' with node=" + n);
                }
                if (!n.getClass().getSimpleName().equals(nodeType)) continue;
                node = n;
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushNode(Node node) {
        this.inStream = null;
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            this.poppedNodes.clear();
            if (this.suppress) {
                this.suppressedNodeStack.push(node);
                return;
            }
            if (this.nodeStack.isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Pushing top level node: " + node + " for txn: " + this.trace);
                }
                this.trace.getNodes().add(node);
            } else {
                Node parent = this.nodeStack.peek();
                if (parent instanceof ContainerNode) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Add node: " + node + " to parent: " + parent + " in txn: " + this.trace);
                    }
                    ((ContainerNode)parent).getNodes().add(node);
                } else {
                    log.severe("Attempt to add node '" + node + "' under non-container node '" + parent + "'");
                }
            }
            this.nodeStack.push(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node popNode(Class<? extends Node> cls, String uri) {
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            if (this.suppress) {
                if (!this.suppressedNodeStack.isEmpty()) {
                    Node suppressed = this.popNode(this.suppressedNodeStack, cls, uri);
                    if (suppressed != null) {
                        return suppressed;
                    }
                } else {
                    this.suppress = false;
                }
            }
            return this.popNode(this.nodeStack, cls, uri);
        }
    }

    protected Node popNode(Stack<Node> stack, Class<? extends Node> cls, String uri) {
        Node top;
        Node node = top = stack.isEmpty() ? null : stack.peek();
        if (top != null) {
            if (this.nodeMatches(top, cls, uri)) {
                Node node2 = stack.pop();
                this.poppedNodes.push(node2);
                return node2;
            }
            for (int i = stack.size() - 2; i >= 0; --i) {
                if (!this.nodeMatches((Node)stack.get(i), cls, uri)) continue;
                Node node3 = (Node)stack.remove(i);
                this.poppedNodes.push(node3);
                return node3;
            }
        }
        return null;
    }

    protected boolean nodeMatches(Node node, Class<? extends Node> cls, String uri) {
        if (node.getClass() == cls) {
            return uri == null || NodeUtil.isOriginalURI(node, uri);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            Node current = this.getCurrentNode();
            if (current != null) {
                this.retainedNodes.put(id, current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node releaseNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            return this.retainedNodes.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node retrieveNode(String id) {
        Map<String, Node> map = this.retainedNodes;
        synchronized (map) {
            return this.retainedNodes.get(id);
        }
    }

    public void addUncompletedCorrelationId(String id, Node node, int position) {
        NodePlaceholder placeholder = new NodePlaceholder();
        placeholder.setNode(node);
        placeholder.setPosition(position);
        this.uncompletedCorrelationIdsNodeMap.put(id, placeholder);
    }

    public Set<String> getUncompletedCorrelationIds() {
        return this.uncompletedCorrelationIdsNodeMap.keySet();
    }

    public int getUncompletedCorrelationIdPosition(String id) {
        if (this.uncompletedCorrelationIdsNodeMap.containsKey(id)) {
            return this.uncompletedCorrelationIdsNodeMap.get(id).getPosition();
        }
        return -1;
    }

    public Node removeUncompletedCorrelationId(String id) {
        NodePlaceholder placeholder = this.uncompletedCorrelationIdsNodeMap.remove(id);
        if (placeholder != null) {
            return placeholder.getNode();
        }
        return null;
    }

    public void suppress() {
        this.suppress = true;
    }

    public boolean isSuppressed() {
        return this.suppress;
    }

    public void ignoreNode() {
        Node node = this.getCurrentNode();
        if (node != null) {
            this.ignoredNodes.add(node);
        }
    }

    public void initInBuffer(int hashCode) {
        this.inHashCode = hashCode;
        this.inStream = new ByteArrayOutputStream();
    }

    public boolean isInBufferActive(int hashCode) {
        return this.inStream != null && (hashCode == -1 || hashCode == this.inHashCode);
    }

    public void writeInData(int hashCode, byte[] b, int offset, int len) {
        if (this.inStream != null && (hashCode == -1 || hashCode == this.inHashCode)) {
            this.inStream.write(b, offset, len);
        }
    }

    public byte[] getInData(int hashCode) {
        if (this.inStream != null && (hashCode == -1 || hashCode == this.inHashCode)) {
            try {
                this.inStream.close();
            }
            catch (IOException e) {
                log.severe("Failed to close in data stream: " + e);
            }
            byte[] b = this.inStream.toByteArray();
            this.inStream = null;
            return b;
        }
        return null;
    }

    public void initOutBuffer(int hashCode) {
        this.outHashCode = hashCode;
        this.outStream = new ByteArrayOutputStream();
    }

    public boolean isOutBufferActive(int hashCode) {
        return this.outStream != null && (hashCode == -1 || hashCode == this.outHashCode);
    }

    public void writeOutData(int hashCode, byte[] b, int offset, int len) {
        if (this.outStream != null && (hashCode == -1 || hashCode == this.outHashCode)) {
            this.outStream.write(b, offset, len);
        }
    }

    public byte[] getOutData(int hashCode) {
        if (this.outStream != null && (hashCode == -1 || hashCode == this.outHashCode)) {
            try {
                this.outStream.close();
            }
            catch (IOException e) {
                log.severe("Failed to close out data stream: " + e);
            }
            byte[] b = this.outStream.toByteArray();
            this.outStream = null;
            return b;
        }
        return null;
    }

    public void setState(Object context, String name, Object value) {
        StateInformation si = this.stateInformation.get(name);
        if (si == null) {
            si = new StateInformation();
            this.stateInformation.put(name, si);
        }
        si.set(context, value);
    }

    public Object getState(Object context, String name) {
        StateInformation si = this.stateInformation.get(name);
        if (si == null) {
            return null;
        }
        return si.get(context);
    }

    public int getThreadCount() {
        return this.threadCount.get();
    }

    protected int incrementThreadCount() {
        return this.threadCount.incrementAndGet();
    }

    protected int decrementThreadCount() {
        return this.threadCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder info = new StringBuilder(256);
        info.append("Fragment builder: current btxn=[");
        info.append(this.trace);
        info.append("] complete=");
        info.append(this.isComplete());
        info.append(" uncompletedCorrelationIdsNodeMap=");
        info.append(this.uncompletedCorrelationIdsNodeMap);
        info.append(" stack=\r\n");
        Stack<Node> stack = this.nodeStack;
        synchronized (stack) {
            for (Node node : this.nodeStack) {
                info.append("         node: ");
                info.append(node);
                info.append("\r\n");
            }
        }
        return info.toString();
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.severe("Unable to determine host name");
        }
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.severe("Unable to determine host address");
        }
    }

    public static class StateInformation {
        private Object noContextValue = null;
        private Map<Object, Object> contextToValueMap = new HashMap<Object, Object>();

        public void set(Object context, Object value) {
            if (context == null) {
                this.noContextValue = value;
            } else {
                this.contextToValueMap.put(context, value);
            }
        }

        public Object get(Object context) {
            if (context == null) {
                return this.noContextValue;
            }
            return this.contextToValueMap.get(context);
        }

        public void remove(Object context) {
            if (context == null) {
                this.noContextValue = null;
            } else {
                this.contextToValueMap.remove(context);
            }
        }
    }

    public static class NodePlaceholder {
        private Node node;
        private int position = -1;

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String toString() {
            return "NodePlaceholder [node=" + this.node + ", position=" + this.position + "]";
        }
    }
}

