/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.instrumenter.headers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.client.api.HeadersAccessor;

public class IterableMapEntryHeadersAccessor
implements HeadersAccessor {
    private static final Logger log = Logger.getLogger(IterableMapEntryHeadersAccessor.class.getName());
    private static final String TARGET_TYPE = "java.lang.Iterable<Map.Entry>";

    @Override
    public String getTargetType() {
        return TARGET_TYPE;
    }

    @Override
    public Map<String, String> getHeaders(Object target) {
        try {
            Iterable iterable = (Iterable)target;
            Iterator iter = iterable.iterator();
            HashMap<String, String> ret = new HashMap<String, String>();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                ret.put((String)entry.getKey(), entry.getValue().toString());
            }
            return ret;
        }
        catch (Throwable t) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.log(Logger.Level.FINEST, "Failed to obtain headers", t);
            }
            return null;
        }
    }
}

