/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.shaded.com.jayway.jsonpath.internal.function.numeric;

import java.util.List;
import org.hawkular.apm.shaded.com.jayway.jsonpath.JsonPathException;
import org.hawkular.apm.shaded.com.jayway.jsonpath.internal.EvaluationContext;
import org.hawkular.apm.shaded.com.jayway.jsonpath.internal.PathRef;
import org.hawkular.apm.shaded.com.jayway.jsonpath.internal.function.Parameter;
import org.hawkular.apm.shaded.com.jayway.jsonpath.internal.function.PathFunction;

public abstract class AbstractAggregation
implements PathFunction {
    protected abstract void next(Number var1);

    protected abstract Number getValue();

    @Override
    public Object invoke(String currentPath, PathRef parent, Object model, EvaluationContext ctx, List<Parameter> parameters) {
        int count = 0;
        if (ctx.configuration().jsonProvider().isArray(model)) {
            Iterable<?> objects = ctx.configuration().jsonProvider().toIterable(model);
            for (Object obj : objects) {
                if (!(obj instanceof Number)) continue;
                Number value = (Number)obj;
                ++count;
                this.next(value);
            }
        }
        if (parameters != null) {
            for (Parameter param : parameters) {
                if (!(param.getCachedValue() instanceof Number)) continue;
                Number value = (Number)param.getCachedValue();
                ++count;
                this.next(value);
            }
        }
        if (count != 0) {
            return this.getValue();
        }
        throw new JsonPathException("Aggregation function attempted to calculate value using empty array");
    }
}

