/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EncoderDecoder {
    protected abstract JAXBContext getContext() throws JAXBException;

    public abstract String getWSRMNamespace();

    public abstract String getWSANamespace();

    public abstract RMConstants getConstants();

    public abstract Class<?> getCreateSequenceType();

    public abstract Class<?> getCreateSequenceResponseType();

    public abstract Class<?> getTerminateSequenceType();

    public abstract Class<?> getTerminateSequenceResponseType();

    public Element buildHeaders(RMProperties rmps, QName qname) throws JAXBException {
        SequenceType seq = rmps.getSequence();
        Collection<SequenceAcknowledgement> acks = rmps.getAcks();
        Collection<AckRequestedType> reqs = rmps.getAcksRequested();
        if (seq == null && acks == null && reqs == null) {
            return null;
        }
        Document doc = DOMUtils.createDocument();
        Element header = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        this.addNamespaceDecl(header);
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        this.buildHeaders(seq, acks, reqs, rmps.isLastMessage(), header, marshaller);
        return header;
    }

    protected void addNamespaceDecl(Element element) {
        Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsrm");
        attr.setValue(this.getWSRMNamespace());
        element.setAttributeNodeNS(attr);
    }

    public Element buildHeaderFault(SequenceFault sf, QName qname) throws JAXBException {
        Document doc = DOMUtils.createDocument();
        Element header = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        this.addNamespaceDecl(header);
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        this.buildHeaderFault(sf, header, marshaller);
        return header;
    }

    protected abstract void buildHeaders(SequenceType var1, Collection<SequenceAcknowledgement> var2, Collection<AckRequestedType> var3, boolean var4, Element var5, Marshaller var6) throws JAXBException;

    protected abstract void buildHeaderFault(SequenceFault var1, Element var2, Marshaller var3) throws JAXBException;

    public abstract Element encodeSequenceAcknowledgement(SequenceAcknowledgement var1) throws JAXBException;

    public abstract Element encodeIdentifier(Identifier var1) throws JAXBException;

    public abstract SequenceType decodeSequenceType(Element var1) throws JAXBException;

    public abstract CloseSequenceType decodeSequenceTypeCloseSequence(Element var1) throws JAXBException;

    public abstract SequenceAcknowledgement decodeSequenceAcknowledgement(Element var1) throws JAXBException;

    public abstract AckRequestedType decodeAckRequestedType(Element var1) throws JAXBException;

    public abstract Object convertToSend(CreateSequenceType var1);

    public abstract Object convertToSend(CreateSequenceResponseType var1);

    public abstract Object convertToSend(TerminateSequenceType var1);

    public abstract TerminateSequenceType convertReceivedTerminateSequence(Object var1);

    public abstract CreateSequenceType convertReceivedCreateSequence(Object var1);

    public abstract CreateSequenceResponseType convertReceivedCreateSequenceResponse(Object var1);
}

