/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentUnitPhaseBuilder;
import org.wildfly.extension.clustering.singleton.deployment.SingletonSubDeploymentUnitPhaseBuilder;

public class SingletonDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<SingletonPolicy> POLICY_KEY = AttachmentKey.create(SingletonPolicy.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        SingletonPolicy policy = (SingletonPolicy)context.getAttachment(POLICY_KEY);
        if (policy != null) {
            DeploymentUnit parent = context.getDeploymentUnit().getParent();
            Object builder = parent == null ? new SingletonDeploymentUnitPhaseBuilder(policy) : new SingletonSubDeploymentUnitPhaseBuilder(parent, context.getPhase().next());
            context.putAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_BUILDER, builder);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }
}

