/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.hawkular.apm.api.model.PropertyType;
import org.hawkular.apm.api.utils.SerializationUtil;

public class Property
implements Externalizable {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String value;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private PropertyType type = PropertyType.Text;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double number;

    public Property() {
    }

    public Property(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Property(String name, String value, PropertyType type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public Double getNumber() {
        if (this.number == null && this.value != null && this.type == PropertyType.Number) {
            try {
                return Double.valueOf(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.number;
    }

    public void setNumber(Double number) {
        this.number = number;
    }

    public String toString() {
        return "Property [name=" + this.name + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + ", number=" + this.number + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        this.name = SerializationUtil.deserializeString(ois);
        this.value = SerializationUtil.deserializeString(ois);
        this.type = PropertyType.values()[ois.readInt()];
        this.number = ois.readDouble();
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        oos.writeInt(1);
        SerializationUtil.serializeString(oos, this.name);
        SerializationUtil.serializeString(oos, this.value);
        oos.writeInt(this.type.ordinal());
        oos.writeDouble(this.number == null ? 0.0 : this.number);
    }
}

