/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.shaded.org.mvel2.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.shaded.org.mvel2.ConversionException;
import org.hawkular.apm.shaded.org.mvel2.ConversionHandler;
import org.hawkular.apm.shaded.org.mvel2.conversion.Converter;

public class IntegerCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>(10);

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(Object.class, new Converter(){

            public Object convert(Object o) {
                if (((String)o).length() == 0) {
                    return 0;
                }
                return Integer.parseInt(String.valueOf(o));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Integer convert(Object o) {
                return ((BigDecimal)o).intValue();
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public Integer convert(Object o) {
                return ((BigInteger)o).intValue();
            }
        });
        CNV.put(String.class, new Converter(){

            public Object convert(Object o) {
                return Integer.parseInt((String)o);
            }
        });
        CNV.put(Short.class, new Converter(){

            public Object convert(Object o) {
                return ((Short)o).intValue();
            }
        });
        CNV.put(Long.class, new Converter(){

            public Object convert(Object o) {
                if ((Long)o > Integer.MAX_VALUE) {
                    throw new ConversionException("cannot coerce Long to Integer since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return ((Long)o).intValue();
            }
        });
        CNV.put(Float.class, new Converter(){

            public Object convert(Object o) {
                if (((Float)o).floatValue() > 2.1474836E9f) {
                    throw new ConversionException("cannot coerce Float to Integer since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return ((Float)o).intValue();
            }
        });
        CNV.put(Double.class, new Converter(){

            public Object convert(Object o) {
                if ((Double)o > 2.147483647E9) {
                    throw new ConversionException("cannot coerce Long to Integer since the value (" + String.valueOf(o) + ") exceeds that maximum precision of Integer.");
                }
                return ((Double)o).intValue();
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Object convert(Object o) {
                return o;
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Integer convert(Object o) {
                if (((Boolean)o).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        });
        CNV.put(Character.class, new Converter(){

            public Integer convert(Object o) {
                return ((Character)o).charValue();
            }
        });
    }
}

