/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.shaded.org.mvel2.integration.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.shaded.org.mvel2.ParserContext;
import org.hawkular.apm.shaded.org.mvel2.integration.VariableResolver;
import org.hawkular.apm.shaded.org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.hawkular.apm.shaded.org.mvel2.integration.impl.StaticMethodImportResolver;
import org.hawkular.apm.shaded.org.mvel2.util.MethodStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodImportResolverFactory
extends BaseVariableResolverFactory {
    public StaticMethodImportResolverFactory(ParserContext ctx) {
        this.variableResolvers = new HashMap();
        for (Map.Entry<String, Object> entry : ctx.getImports().entrySet()) {
            if (!(entry.getValue() instanceof Method)) continue;
            this.createVariable(entry.getKey(), entry.getValue());
        }
    }

    public StaticMethodImportResolverFactory() {
        this.variableResolvers = new HashMap();
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        if (value instanceof Method) {
            value = new MethodStub((Method)value);
        }
        StaticMethodImportResolver methodResolver = new StaticMethodImportResolver(name, (MethodStub)value);
        this.variableResolvers.put(name, methodResolver);
        return methodResolver;
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        return null;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    @Override
    public boolean isResolveable(String name) {
        return this.isTarget(name) || this.isNextResolveable(name);
    }

    public Map<String, Method> getImportedMethods() {
        HashMap<String, Method> im = new HashMap<String, Method>();
        for (Map.Entry e : this.variableResolvers.entrySet()) {
            im.put((String)e.getKey(), (Method)((VariableResolver)e.getValue()).getValue());
        }
        return im;
    }
}

