/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.shaded.org.mvel2.util;

import java.io.UnsupportedEncodingException;

public class StringAppender
implements CharSequence {
    private static final int DEFAULT_SIZE = 15;
    private char[] str;
    private int capacity;
    private int size = 0;
    private byte[] btr;
    private String encoding;

    public StringAppender() {
        this.capacity = 15;
        this.str = new char[15];
    }

    public StringAppender(int capacity) {
        this.capacity = capacity;
        this.str = new char[this.capacity];
    }

    public StringAppender(int capacity, String encoding) {
        this.capacity = capacity;
        this.str = new char[this.capacity];
        this.encoding = encoding;
    }

    public StringAppender(char c) {
        this.capacity = 15;
        char[] cArray = new char[15];
        this.str = cArray;
        cArray[0] = c;
    }

    public StringAppender(char[] s) {
        this.str = s;
        this.capacity = this.size = s.length;
    }

    public StringAppender(CharSequence s) {
        this.capacity = this.size = s.length();
        this.str = new char[this.size];
        for (int i = 0; i < this.str.length; ++i) {
            this.str[i] = s.charAt(i);
        }
    }

    public StringAppender(String s) {
        this.str = s.toCharArray();
        this.capacity = this.size = this.str.length;
    }

    public StringAppender append(char[] chars) {
        if (chars.length > this.capacity - this.size) {
            this.grow(chars.length);
        }
        int i = 0;
        while (i < chars.length) {
            this.str[this.size] = chars[i++];
            ++this.size;
        }
        return this;
    }

    public StringAppender append(byte[] chars) {
        if (chars.length > this.capacity - this.size) {
            this.grow(chars.length);
        }
        int i = 0;
        while (i < chars.length) {
            this.str[this.size] = (char)chars[i++];
            ++this.size;
        }
        return this;
    }

    public StringAppender append(char[] chars, int start, int length) {
        if (length > this.capacity - this.size) {
            this.grow(length);
        }
        int x = start + length;
        for (int i = start; i < x; ++i) {
            this.str[this.size++] = chars[i];
        }
        return this;
    }

    public StringAppender append(byte[] chars, int start, int length) {
        if (length > this.capacity - this.size) {
            this.grow(length);
        }
        int x = start + length;
        for (int i = start; i < x; ++i) {
            this.str[this.size++] = (char)chars[i];
        }
        return this;
    }

    public StringAppender append(Object o) {
        return this.append(String.valueOf(o));
    }

    public StringAppender append(CharSequence s) {
        if (s.length() > this.capacity - this.size) {
            this.grow(s.length());
        }
        int i = 0;
        while (i < s.length()) {
            this.str[this.size] = s.charAt(i++);
            ++this.size;
        }
        return this;
    }

    public StringAppender append(String s) {
        if (s == null) {
            return this;
        }
        int len = s.length();
        if (len > this.capacity - this.size) {
            this.grow(len);
        }
        s.getChars(0, len, this.str, this.size);
        this.size += len;
        return this;
    }

    public StringAppender append(char c) {
        if (this.size >= this.capacity) {
            this.grow(this.size);
        }
        this.str[this.size++] = c;
        return this;
    }

    public StringAppender append(byte b) {
        if (this.btr == null) {
            this.capacity = 15;
            this.btr = new byte[15];
        }
        if (this.size >= this.capacity) {
            this.growByte(this.size * 2);
        }
        this.btr[this.size++] = b;
        return this;
    }

    public int length() {
        return this.size;
    }

    private void grow(int s) {
        if (this.capacity == 0) {
            this.capacity = 15;
        }
        char[] newArray = new char[this.capacity += s * 2];
        System.arraycopy(this.str, 0, newArray, 0, this.size);
        this.str = newArray;
    }

    private void growByte(int s) {
        byte[] newByteArray = new byte[this.capacity += s];
        System.arraycopy(this.btr, 0, newByteArray, 0, this.size);
        this.btr = newByteArray;
    }

    public char[] getChars(int start, int count) {
        char[] chars = new char[count];
        System.arraycopy(this.str, start, chars, 0, count);
        return chars;
    }

    public char[] toChars() {
        if (this.btr != null) {
            String s;
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding");
            }
            try {
                s = new String(this.btr, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                s = new String(this.btr);
            }
            return s.toCharArray();
        }
        char[] chars = new char[this.size];
        System.arraycopy(this.str, 0, chars, 0, this.size);
        return chars;
    }

    public String toString() {
        if (this.btr != null) {
            String s;
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding");
            }
            try {
                s = new String(this.btr, 0, this.size, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                s = new String(this.btr, 0, this.size);
            }
            return s;
        }
        if (this.size == this.capacity) {
            return new String(this.str);
        }
        return new String(this.str, 0, this.size);
    }

    public void getChars(int start, int count, char[] target, int offset) {
        int delta = offset;
        for (int i = start; i < count; ++i) {
            target[delta++] = this.str[i];
        }
    }

    public void reset() {
        this.size = 0;
    }

    public char charAt(int index) {
        return this.str[index];
    }

    public CharSequence substring(int start, int end) {
        return new String(this.str, start, end - start);
    }

    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }
}

