/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.Type;

public class IndexParamAccessTriggerAdapter
extends RuleTriggerAdapter {
    private int paramIdx;
    private int flags;
    private int count;
    private boolean whenComplete;

    public IndexParamAccessTriggerAdapter(ClassVisitor cv, TransformContext transformContext, int paramIdx, int flags, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.paramIdx = paramIdx;
        this.flags = flags;
        this.count = count;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            int paramSlotIdx = Type.paramSlotIdx(access, desc, this.paramIdx);
            if (name.equals("<init>")) {
                return new IndexParamAccessTriggerConstructorAdapter(mv, this.getTransformContext(), paramSlotIdx, access, name, desc, signature, exceptions);
            }
            return new IndexParamAccessTriggerMethodAdapter(mv, this.getTransformContext(), paramSlotIdx, access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class IndexParamAccessTriggerConstructorAdapter
    extends IndexParamAccessTriggerMethodAdapter {
        IndexParamAccessTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int paramSlotIdx, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, paramSlotIdx, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.latched && IndexParamAccessTriggerAdapter.this.isSuperOrSiblingConstructorCall(opcode, owner, name)) {
                this.latched = false;
            }
        }
    }

    private class IndexParamAccessTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean latched;
        private int index;
        private int visitedCount;

        IndexParamAccessTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int paramSlotIdx, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.index = paramSlotIdx;
            this.visitedCount = 0;
            this.latched = false;
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            if (this.inBytemanTrigger()) {
                super.visitVarInsn(opcode, var);
            } else {
                if (IndexParamAccessTriggerAdapter.this.whenComplete) {
                    super.visitVarInsn(opcode, var);
                }
                if (var == this.index && (IndexParamAccessTriggerAdapter.this.count == 0 || this.visitedCount < IndexParamAccessTriggerAdapter.this.count) && this.matchCall(opcode)) {
                    ++this.visitedCount;
                    if (!(this.latched || IndexParamAccessTriggerAdapter.this.count != 0 && this.visitedCount != IndexParamAccessTriggerAdapter.this.count)) {
                        this.injectTriggerPoint();
                    }
                }
                if (!IndexParamAccessTriggerAdapter.this.whenComplete) {
                    super.visitVarInsn(opcode, var);
                }
            }
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            boolean ruleIsAfterWrite;
            boolean bl = ruleIsAfterWrite = (IndexParamAccessTriggerAdapter.this.flags & 2) != 0 && IndexParamAccessTriggerAdapter.this.whenComplete;
            if (ruleIsAfterWrite) {
                super.visitIincInsn(var, increment);
            }
            if (var == this.index && (IndexParamAccessTriggerAdapter.this.count == 0 || this.visitedCount < IndexParamAccessTriggerAdapter.this.count)) {
                ++this.visitedCount;
                if (!(this.latched || IndexParamAccessTriggerAdapter.this.count != 0 && this.visitedCount != IndexParamAccessTriggerAdapter.this.count)) {
                    this.injectTriggerPoint();
                }
            }
            if (!ruleIsAfterWrite) {
                super.visitIincInsn(var, increment);
            }
        }

        private boolean matchCall(int opcode) {
            if (opcode < 54) {
                return (IndexParamAccessTriggerAdapter.this.flags & 1) != 0;
            }
            return (IndexParamAccessTriggerAdapter.this.flags & 2) != 0;
        }
    }
}

