/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.MemoryType;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.MemoryMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanReadResourceHandler;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanResetPeakUsageHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelType;

class MemoryPoolResourceDefinition
extends SimpleResourceDefinition {
    private static AttributeDefinition MEMORY_MANAGER_NAMES = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("memory-manager-names").setStorageRuntime()).build();
    private static AttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"type", (ModelType)ModelType.STRING, (boolean)false).setValidator((ParameterValidator)new EnumValidator(MemoryType.class, false, (Enum[])new MemoryType[0]))).setStorageRuntime()).build();
    private static AttributeDefinition USAGE_THRESHOLD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"usage-threshold", (ModelType)ModelType.LONG, (boolean)true).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.BYTES)).setValidator((ParameterValidator)new IntRangeValidator(0))).build();
    private static AttributeDefinition USAGE_THRESHOLD_EXCEEDED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"usage-threshold-exceeded", (ModelType)ModelType.BOOLEAN, (boolean)true).setStorageRuntime()).build();
    private static AttributeDefinition USAGE_THRESHOLD_SUPPORTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"usage-threshold-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    private static AttributeDefinition USAGE_THRESHOLD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"usage-threshold-count", (ModelType)ModelType.LONG, (boolean)true).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.NONE)).build();
    private static AttributeDefinition COLLECTION_USAGE_THRESHOLD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"collection-usage-threshold-count", (ModelType)ModelType.LONG, (boolean)true).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.NONE)).build();
    private static AttributeDefinition COLLECTION_USAGE_THRESHOLD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"collection-usage-threshold", (ModelType)ModelType.LONG, (boolean)true).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.BYTES)).setValidator((ParameterValidator)new IntRangeValidator(0))).build();
    private static AttributeDefinition COLLECTION_USAGE_THRESHOLD_SUPPORTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"collection-usage-threshold-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    private static AttributeDefinition COLLECTION_USAGE_THRESHOLD_EXCEEDED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"collection-usage-threshold-exceeded", (ModelType)ModelType.BOOLEAN, (boolean)true).setStorageRuntime()).build();
    private static AttributeDefinition USAGE = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("usage", new AttributeDefinition[]{PlatformMBeanConstants.MEMORY_INIT, PlatformMBeanConstants.MEMORY_USED, PlatformMBeanConstants.MEMORY_COMMITTED, PlatformMBeanConstants.MEMORY_MAX}).setStorageRuntime()).setAllowNull(false).build();
    private static AttributeDefinition PEAK_USAGE = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("peak-usage", new AttributeDefinition[]{PlatformMBeanConstants.MEMORY_INIT, PlatformMBeanConstants.MEMORY_USED, PlatformMBeanConstants.MEMORY_COMMITTED, PlatformMBeanConstants.MEMORY_MAX}).setStorageRuntime()).setAllowNull(false).build();
    private static AttributeDefinition COLLECTION_USAGE = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("collection-usage", new AttributeDefinition[]{PlatformMBeanConstants.MEMORY_INIT, PlatformMBeanConstants.MEMORY_USED, PlatformMBeanConstants.MEMORY_COMMITTED, PlatformMBeanConstants.MEMORY_MAX}).setStorageRuntime()).build();
    private static final List<AttributeDefinition> METRICS = Arrays.asList(USAGE, PEAK_USAGE, USAGE_THRESHOLD_EXCEEDED, USAGE_THRESHOLD_COUNT, COLLECTION_USAGE_THRESHOLD_EXCEEDED, COLLECTION_USAGE_THRESHOLD_COUNT, COLLECTION_USAGE);
    private static final List<AttributeDefinition> READ_WRITE_ATTRIBUTES = Arrays.asList(USAGE_THRESHOLD, COLLECTION_USAGE_THRESHOLD);
    private static final List<AttributeDefinition> READ_ATTRIBUTES = Arrays.asList(PlatformMBeanConstants.NAME, TYPE, PlatformMBeanConstants.VALID, MEMORY_MANAGER_NAMES, USAGE_THRESHOLD_SUPPORTED, COLLECTION_USAGE_THRESHOLD_SUPPORTED);
    static final List<String> MEMORY_POOL_METRICS = Arrays.asList(USAGE.getName(), PEAK_USAGE.getName(), USAGE_THRESHOLD_EXCEEDED.getName(), USAGE_THRESHOLD_COUNT.getName(), COLLECTION_USAGE_THRESHOLD_EXCEEDED.getName(), COLLECTION_USAGE_THRESHOLD_COUNT.getName(), COLLECTION_USAGE.getName());
    static final List<String> MEMORY_POOL_READ_WRITE_ATTRIBUTES = Arrays.asList(USAGE_THRESHOLD.getName(), COLLECTION_USAGE_THRESHOLD.getName());
    static final List<String> MEMORY_POOL_READ_ATTRIBUTES = Arrays.asList(PlatformMBeanConstants.NAME.getName(), TYPE.getName(), PlatformMBeanConstants.VALID.getName(), MEMORY_MANAGER_NAMES.getName(), USAGE_THRESHOLD_SUPPORTED.getName(), COLLECTION_USAGE_THRESHOLD_SUPPORTED.getName());
    static final MemoryPoolResourceDefinition INSTANCE = new MemoryPoolResourceDefinition();

    private MemoryPoolResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)PlatformMBeanConstants.NAME.getName()), (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("memory-pool")).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        registration.registerReadOnlyAttribute((AttributeDefinition)PlatformMBeanConstants.OBJECT_NAME, (OperationStepHandler)MemoryMXBeanAttributeHandler.INSTANCE);
        for (AttributeDefinition attribute : READ_WRITE_ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, (OperationStepHandler)MemoryPoolMXBeanAttributeHandler.INSTANCE, (OperationStepHandler)MemoryPoolMXBeanAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition attribute : READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)MemoryPoolMXBeanAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition attribute : METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)MemoryPoolMXBeanAttributeHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(ReadResourceHandler.DEFINITION, (OperationStepHandler)MemoryPoolMXBeanReadResourceHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(MemoryPoolMXBeanResetPeakUsageHandler.DEFINITION, (OperationStepHandler)MemoryPoolMXBeanResetPeakUsageHandler.INSTANCE);
    }
}

