/*
 * Decompiled with CFR 0.152.
 */
package org.jipijapa.eclipselink;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.jboss.logging.Logger;

public class JBossLogger
extends AbstractSessionLog {
    private static final String ORG_ECLIPSE_PERSISTENCE = "org.eclipse.persistence";
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    public void log(SessionLogEntry sessionLogEntry) {
        Logger logger = this.getLoggerForCategory(sessionLogEntry.getNameSpace());
        Logger.Level level = this.convertLevelIntToEnum(sessionLogEntry.getLevel());
        String message = this.formatMessage(sessionLogEntry);
        logger.log(level, (Object)message);
    }

    public boolean shouldLog(int level, String category) {
        return this.getLoggerForCategory(category).isEnabled(this.convertLevelIntToEnum(level));
    }

    private Logger getLoggerForCategory(String category) {
        Logger logger = this.loggers.get(category);
        if (logger == null) {
            logger = Logger.getLogger((String)ORG_ECLIPSE_PERSISTENCE, (String)(category == null ? "" : category));
            this.loggers.put(category, logger);
        }
        return logger;
    }

    private Logger.Level convertLevelIntToEnum(int level) {
        switch (level) {
            case 7: {
                return Logger.Level.FATAL;
            }
            case 6: {
                return Logger.Level.WARN;
            }
            case 4: 
            case 5: {
                return Logger.Level.INFO;
            }
            case 3: {
                return Logger.Level.DEBUG;
            }
            case 1: 
            case 2: {
                return Logger.Level.TRACE;
            }
        }
        this.getLoggerForCategory("logging").warnv("Received message for log level {0}, but no such level is defined in SessionLog! Logging at INFO level...", (Object)level);
        return Logger.Level.INFO;
    }

    public boolean shouldDisplayData() {
        if (this.shouldDisplayData == null) {
            return this.getLoggerForCategory("sql").isDebugEnabled();
        }
        return this.shouldDisplayData;
    }
}

