/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.NoopExtensionFunction;
import java.io.IOException;
import java.util.List;

public class CompositeExtensionFunction
implements ExtensionFunction {
    private final ExtensionFunction[] delegates;

    private CompositeExtensionFunction(ExtensionFunction ... delegates) {
        this.delegates = delegates;
    }

    public static ExtensionFunction compose(List<ExtensionFunction> functions) {
        if (null == functions) {
            return NoopExtensionFunction.instance;
        }
        return CompositeExtensionFunction.compose(functions.toArray(new ExtensionFunction[functions.size()]));
    }

    public static ExtensionFunction compose(ExtensionFunction ... functions) {
        if (functions == null || functions.length == 0) {
            return NoopExtensionFunction.instance;
        }
        if (functions.length == 1) {
            return functions[0];
        }
        return new CompositeExtensionFunction(functions);
    }

    @Override
    public boolean hasExtensionOpCode() {
        for (ExtensionFunction delegate : this.delegates) {
            if (!delegate.hasExtensionOpCode()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int writeRsv(int rsv) {
        for (ExtensionFunction ext : this.delegates) {
            rsv = ext.writeRsv(rsv);
        }
        return rsv;
    }

    @Override
    public PooledByteBuffer transformForWrite(PooledByteBuffer pooledBuffer, WebSocketChannel channel) throws IOException {
        PooledByteBuffer result = pooledBuffer;
        for (ExtensionFunction delegate : this.delegates) {
            result = delegate.transformForWrite(result, channel);
        }
        return result;
    }

    @Override
    public PooledByteBuffer transformForRead(PooledByteBuffer pooledBuffer, WebSocketChannel channel, boolean lastFragmentOfFrame) throws IOException {
        PooledByteBuffer result = pooledBuffer;
        for (ExtensionFunction delegate : this.delegates) {
            result = delegate.transformForRead(result, channel, lastFragmentOfFrame);
        }
        return result;
    }

    @Override
    public void dispose() {
        for (ExtensionFunction delegate : this.delegates) {
            delegate.dispose();
        }
    }
}

