/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.examples.vertx.opentracing.inventorymanager;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.hawkular.apm.client.opentracing.APMTracer;
import org.hawkular.apm.examples.vertx.opentracing.common.VertxMessageExtractAdapter;

public class InventoryManagerVerticle
extends AbstractVerticle {
    private static final Logger logger = Logger.getLogger(InventoryManagerVerticle.class.getName());
    private Tracer tracer = new APMTracer();
    private Map<String, JsonObject> items = new HashMap<String, JsonObject>();

    public static void main(String[] args) {
        logger.info("Starting [InventoryManagerVerticle] from its `main` method. Consider starting it from vertx.");
        Vertx vertx = Vertx.vertx();
        vertx.deployVerticle((Verticle)new InventoryManagerVerticle());
    }

    public void start(Future<Void> startFuture) throws Exception {
        logger.info("Starting Inventory Manager");
        this.items.put("laptop", new JsonObject().put("itemId", "laptop").put("quantity", Integer.valueOf(5)));
        this.items.put("car", new JsonObject().put("itemId", "car").put("quantity", Integer.valueOf(8)));
        this.items.put("book", new JsonObject().put("itemId", "book").put("quantity", Integer.valueOf(9)));
        this.items.put("chair", new JsonObject().put("itemId", "chair").put("quantity", Integer.valueOf(7)));
        this.items.put("dvd", new JsonObject().put("itemId", "dvd").put("quantity", Integer.valueOf(6)));
        this.setupConsumers();
    }

    private void setupConsumers() {
        logger.info("Setting up consumers");
        this.getVertx().eventBus().consumer("joined").handler(message -> logger.info(String.format("Acknowledging that %s just joined", message.body())));
        MessageConsumer getItemConsumer = this.getVertx().eventBus().consumer("InventoryManager.getItem");
        MessageConsumer ordersConfirmedConsumer = this.getVertx().eventBus().consumer("Orders.confirmed");
        getItemConsumer.handler(message -> {
            block27: {
                JsonObject req = (JsonObject)message.body();
                SpanContext spanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(req));
                try (Span getItemSpan = this.tracer.buildSpan("GetItem").asChildOf(spanCtx).start();){
                    if (!req.containsKey("itemId")) {
                        message.fail(1, "Item id missing");
                        break block27;
                    }
                    try (Span queryInventorySpan = this.tracer.buildSpan("QueryInventory").asChildOf(getItemSpan).withTag("database.url", "InventoryDB").withTag("database.statement", "SELECT item FROM Inventory WHERE id = ?").start();){
                        JsonObject acct = this.items.get(req.getString("itemId"));
                        if (acct == null) {
                            this.sendError(2, "Item not found", (Message<JsonObject>)message, getItemSpan);
                        } else {
                            message.reply((Object)acct);
                        }
                    }
                }
            }
        }).completionHandler(result -> {
            if (result.succeeded()) {
                this.getVertx().eventBus().send("joined", (Object)"InventoryManager.getItem");
                logger.info("Registration has completed.");
            } else {
                logger.warning("Could not register: " + result.cause().getMessage());
            }
        });
        ordersConfirmedConsumer.handler(message -> {
            JsonObject order = (JsonObject)message.body();
            SpanContext spanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(order));
            try (Span orderConfirmedSpan = this.tracer.buildSpan("UpdateQuantity").asChildOf(spanCtx).start();){
                Span queryInventorySpan = this.tracer.buildSpan("WriteInventory").asChildOf(orderConfirmedSpan).withTag("database.url", "InventoryDB").withTag("database.statement", "UPDATE Inventory SET item=?").start();
                Throwable throwable = null;
                if (queryInventorySpan != null) {
                    if (throwable != null) {
                        try {
                            queryInventorySpan.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        queryInventorySpan.close();
                    }
                }
            }
        }).completionHandler(result -> {
            if (result.succeeded()) {
                this.getVertx().eventBus().send("joined", (Object)"Orders.confirmed");
                logger.info("Registration has completed.");
            } else {
                logger.warning("Could not register: " + result.cause().getMessage());
            }
        });
    }

    void sendError(int statusCode, String text, Message<JsonObject> message, Span span) {
        message.fail(statusCode, text);
        if (span != null) {
            span.setTag("fault", text == null ? Integer.toString(statusCode) : text);
        }
    }
}

